/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.DateRange;
import com.squareup.square.types.TimecardWorkdayMatcher;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TimecardWorkday {
    private final Optional<DateRange> dateRange;
    private final Optional<TimecardWorkdayMatcher> matchTimecardsBy;
    private final Optional<String> defaultTimezone;
    private final Map<String, Object> additionalProperties;

    private TimecardWorkday(Optional<DateRange> dateRange, Optional<TimecardWorkdayMatcher> matchTimecardsBy, Optional<String> defaultTimezone, Map<String, Object> additionalProperties) {
        this.dateRange = dateRange;
        this.matchTimecardsBy = matchTimecardsBy;
        this.defaultTimezone = defaultTimezone;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="date_range")
    public Optional<DateRange> getDateRange() {
        return this.dateRange;
    }

    @JsonProperty(value="match_timecards_by")
    public Optional<TimecardWorkdayMatcher> getMatchTimecardsBy() {
        return this.matchTimecardsBy;
    }

    @JsonIgnore
    public Optional<String> getDefaultTimezone() {
        if (this.defaultTimezone == null) {
            return Optional.empty();
        }
        return this.defaultTimezone;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="default_timezone")
    private Optional<String> _getDefaultTimezone() {
        return this.defaultTimezone;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TimecardWorkday && this.equalTo((TimecardWorkday)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TimecardWorkday other) {
        return this.dateRange.equals(other.dateRange) && this.matchTimecardsBy.equals(other.matchTimecardsBy) && this.defaultTimezone.equals(other.defaultTimezone);
    }

    public int hashCode() {
        return Objects.hash(this.dateRange, this.matchTimecardsBy, this.defaultTimezone);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<DateRange> dateRange = Optional.empty();
        private Optional<TimecardWorkdayMatcher> matchTimecardsBy = Optional.empty();
        private Optional<String> defaultTimezone = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TimecardWorkday other) {
            this.dateRange(other.getDateRange());
            this.matchTimecardsBy(other.getMatchTimecardsBy());
            this.defaultTimezone(other.getDefaultTimezone());
            return this;
        }

        @JsonSetter(value="date_range", nulls=Nulls.SKIP)
        public Builder dateRange(Optional<DateRange> dateRange) {
            this.dateRange = dateRange;
            return this;
        }

        public Builder dateRange(DateRange dateRange) {
            this.dateRange = Optional.ofNullable(dateRange);
            return this;
        }

        @JsonSetter(value="match_timecards_by", nulls=Nulls.SKIP)
        public Builder matchTimecardsBy(Optional<TimecardWorkdayMatcher> matchTimecardsBy) {
            this.matchTimecardsBy = matchTimecardsBy;
            return this;
        }

        public Builder matchTimecardsBy(TimecardWorkdayMatcher matchTimecardsBy) {
            this.matchTimecardsBy = Optional.ofNullable(matchTimecardsBy);
            return this;
        }

        @JsonSetter(value="default_timezone", nulls=Nulls.SKIP)
        public Builder defaultTimezone(Optional<String> defaultTimezone) {
            this.defaultTimezone = defaultTimezone;
            return this;
        }

        public Builder defaultTimezone(String defaultTimezone) {
            this.defaultTimezone = Optional.ofNullable(defaultTimezone);
            return this;
        }

        public Builder defaultTimezone(Nullable<String> defaultTimezone) {
            this.defaultTimezone = defaultTimezone.isNull() ? null : (defaultTimezone.isEmpty() ? Optional.empty() : Optional.of(defaultTimezone.get()));
            return this;
        }

        public TimecardWorkday build() {
            return new TimecardWorkday(this.dateRange, this.matchTimecardsBy, this.defaultTimezone, this.additionalProperties);
        }
    }
}

