/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.BreakType;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateBreakTypeResponse {
    private final Optional<BreakType> breakType;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private UpdateBreakTypeResponse(Optional<BreakType> breakType, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.breakType = breakType;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="break_type")
    public Optional<BreakType> getBreakType() {
        return this.breakType;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateBreakTypeResponse && this.equalTo((UpdateBreakTypeResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateBreakTypeResponse other) {
        return this.breakType.equals(other.breakType) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.breakType, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<BreakType> breakType = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(UpdateBreakTypeResponse other) {
            this.breakType(other.getBreakType());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="break_type", nulls=Nulls.SKIP)
        public Builder breakType(Optional<BreakType> breakType) {
            this.breakType = breakType;
            return this;
        }

        public Builder breakType(BreakType breakType) {
            this.breakType = Optional.ofNullable(breakType);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public UpdateBreakTypeResponse build() {
            return new UpdateBreakTypeResponse(this.breakType, this.errors, this.additionalProperties);
        }
    }
}

