/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CheckoutMerchantSettings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateMerchantSettingsRequest {
    private final CheckoutMerchantSettings merchantSettings;
    private final Map<String, Object> additionalProperties;

    private UpdateMerchantSettingsRequest(CheckoutMerchantSettings merchantSettings, Map<String, Object> additionalProperties) {
        this.merchantSettings = merchantSettings;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="merchant_settings")
    public CheckoutMerchantSettings getMerchantSettings() {
        return this.merchantSettings;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateMerchantSettingsRequest && this.equalTo((UpdateMerchantSettingsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateMerchantSettingsRequest other) {
        return this.merchantSettings.equals(other.merchantSettings);
    }

    public int hashCode() {
        return Objects.hash(this.merchantSettings);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static MerchantSettingsStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements MerchantSettingsStage,
    _FinalStage {
        private CheckoutMerchantSettings merchantSettings;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateMerchantSettingsRequest other) {
            this.merchantSettings(other.getMerchantSettings());
            return this;
        }

        @Override
        @JsonSetter(value="merchant_settings")
        public _FinalStage merchantSettings(@NotNull CheckoutMerchantSettings merchantSettings) {
            this.merchantSettings = Objects.requireNonNull(merchantSettings, "merchantSettings must not be null");
            return this;
        }

        @Override
        public UpdateMerchantSettingsRequest build() {
            return new UpdateMerchantSettingsRequest(this.merchantSettings, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateMerchantSettingsRequest build();
    }

    public static interface MerchantSettingsStage {
        public _FinalStage merchantSettings(@NotNull CheckoutMerchantSettings var1);

        public Builder from(UpdateMerchantSettingsRequest var1);
    }
}

