/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Order;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateOrderRequest {
    private final String orderId;
    private final Optional<Order> order;
    private final Optional<List<String>> fieldsToClear;
    private final Optional<String> idempotencyKey;
    private final Map<String, Object> additionalProperties;

    private UpdateOrderRequest(String orderId, Optional<Order> order, Optional<List<String>> fieldsToClear, Optional<String> idempotencyKey, Map<String, Object> additionalProperties) {
        this.orderId = orderId;
        this.order = order;
        this.fieldsToClear = fieldsToClear;
        this.idempotencyKey = idempotencyKey;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="order_id")
    public String getOrderId() {
        return this.orderId;
    }

    @JsonProperty(value="order")
    public Optional<Order> getOrder() {
        return this.order;
    }

    @JsonIgnore
    public Optional<List<String>> getFieldsToClear() {
        if (this.fieldsToClear == null) {
            return Optional.empty();
        }
        return this.fieldsToClear;
    }

    @JsonIgnore
    public Optional<String> getIdempotencyKey() {
        if (this.idempotencyKey == null) {
            return Optional.empty();
        }
        return this.idempotencyKey;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="fields_to_clear")
    private Optional<List<String>> _getFieldsToClear() {
        return this.fieldsToClear;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="idempotency_key")
    private Optional<String> _getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateOrderRequest && this.equalTo((UpdateOrderRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateOrderRequest other) {
        return this.orderId.equals(other.orderId) && this.order.equals(other.order) && this.fieldsToClear.equals(other.fieldsToClear) && this.idempotencyKey.equals(other.idempotencyKey);
    }

    public int hashCode() {
        return Objects.hash(this.orderId, this.order, this.fieldsToClear, this.idempotencyKey);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OrderIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OrderIdStage,
    _FinalStage {
        private String orderId;
        private Optional<String> idempotencyKey = Optional.empty();
        private Optional<List<String>> fieldsToClear = Optional.empty();
        private Optional<Order> order = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateOrderRequest other) {
            this.orderId(other.getOrderId());
            this.order(other.getOrder());
            this.fieldsToClear(other.getFieldsToClear());
            this.idempotencyKey(other.getIdempotencyKey());
            return this;
        }

        @Override
        @JsonSetter(value="order_id")
        public _FinalStage orderId(@NotNull String orderId) {
            this.orderId = Objects.requireNonNull(orderId, "orderId must not be null");
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(Nullable<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey.isNull() ? null : (idempotencyKey.isEmpty() ? Optional.empty() : Optional.of(idempotencyKey.get()));
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = Optional.ofNullable(idempotencyKey);
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key", nulls=Nulls.SKIP)
        public _FinalStage idempotencyKey(Optional<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        @Override
        public _FinalStage fieldsToClear(Nullable<List<String>> fieldsToClear) {
            this.fieldsToClear = fieldsToClear.isNull() ? null : (fieldsToClear.isEmpty() ? Optional.empty() : Optional.of(fieldsToClear.get()));
            return this;
        }

        @Override
        public _FinalStage fieldsToClear(List<String> fieldsToClear) {
            this.fieldsToClear = Optional.ofNullable(fieldsToClear);
            return this;
        }

        @Override
        @JsonSetter(value="fields_to_clear", nulls=Nulls.SKIP)
        public _FinalStage fieldsToClear(Optional<List<String>> fieldsToClear) {
            this.fieldsToClear = fieldsToClear;
            return this;
        }

        @Override
        public _FinalStage order(Order order) {
            this.order = Optional.ofNullable(order);
            return this;
        }

        @Override
        @JsonSetter(value="order", nulls=Nulls.SKIP)
        public _FinalStage order(Optional<Order> order) {
            this.order = order;
            return this;
        }

        @Override
        public UpdateOrderRequest build() {
            return new UpdateOrderRequest(this.orderId, this.order, this.fieldsToClear, this.idempotencyKey, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateOrderRequest build();

        public _FinalStage order(Optional<Order> var1);

        public _FinalStage order(Order var1);

        public _FinalStage fieldsToClear(Optional<List<String>> var1);

        public _FinalStage fieldsToClear(List<String> var1);

        public _FinalStage fieldsToClear(Nullable<List<String>> var1);

        public _FinalStage idempotencyKey(Optional<String> var1);

        public _FinalStage idempotencyKey(String var1);

        public _FinalStage idempotencyKey(Nullable<String> var1);
    }

    public static interface OrderIdStage {
        public _FinalStage orderId(@NotNull String var1);

        public Builder from(UpdateOrderRequest var1);
    }
}

