/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.ScheduledShift;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateScheduledShiftResponse {
    private final Optional<ScheduledShift> scheduledShift;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private UpdateScheduledShiftResponse(Optional<ScheduledShift> scheduledShift, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.scheduledShift = scheduledShift;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="scheduled_shift")
    public Optional<ScheduledShift> getScheduledShift() {
        return this.scheduledShift;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateScheduledShiftResponse && this.equalTo((UpdateScheduledShiftResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateScheduledShiftResponse other) {
        return this.scheduledShift.equals(other.scheduledShift) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.scheduledShift, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<ScheduledShift> scheduledShift = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(UpdateScheduledShiftResponse other) {
            this.scheduledShift(other.getScheduledShift());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="scheduled_shift", nulls=Nulls.SKIP)
        public Builder scheduledShift(Optional<ScheduledShift> scheduledShift) {
            this.scheduledShift = scheduledShift;
            return this;
        }

        public Builder scheduledShift(ScheduledShift scheduledShift) {
            this.scheduledShift = Optional.ofNullable(scheduledShift);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public UpdateScheduledShiftResponse build() {
            return new UpdateScheduledShiftResponse(this.scheduledShift, this.errors, this.additionalProperties);
        }
    }
}

