/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.TeamMember;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateTeamMemberResponse {
    private final Optional<TeamMember> teamMember;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private UpdateTeamMemberResponse(Optional<TeamMember> teamMember, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.teamMember = teamMember;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="team_member")
    public Optional<TeamMember> getTeamMember() {
        return this.teamMember;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateTeamMemberResponse && this.equalTo((UpdateTeamMemberResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateTeamMemberResponse other) {
        return this.teamMember.equals(other.teamMember) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.teamMember, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<TeamMember> teamMember = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(UpdateTeamMemberResponse other) {
            this.teamMember(other.getTeamMember());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="team_member", nulls=Nulls.SKIP)
        public Builder teamMember(Optional<TeamMember> teamMember) {
            this.teamMember = teamMember;
            return this;
        }

        public Builder teamMember(TeamMember teamMember) {
            this.teamMember = Optional.ofNullable(teamMember);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public UpdateTeamMemberResponse build() {
            return new UpdateTeamMemberResponse(this.teamMember, this.errors, this.additionalProperties);
        }
    }
}

