/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.UpdateVendorRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateVendorsRequest {
    private final String vendorId;
    private final UpdateVendorRequest body;
    private final Map<String, Object> additionalProperties;

    private UpdateVendorsRequest(String vendorId, UpdateVendorRequest body, Map<String, Object> additionalProperties) {
        this.vendorId = vendorId;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="vendor_id")
    public String getVendorId() {
        return this.vendorId;
    }

    @JsonProperty(value="body")
    public UpdateVendorRequest getBody() {
        return this.body;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateVendorsRequest && this.equalTo((UpdateVendorsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateVendorsRequest other) {
        return this.vendorId.equals(other.vendorId) && this.body.equals(other.body);
    }

    public int hashCode() {
        return Objects.hash(this.vendorId, this.body);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static VendorIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements VendorIdStage,
    BodyStage,
    _FinalStage {
        private String vendorId;
        private UpdateVendorRequest body;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateVendorsRequest other) {
            this.vendorId(other.getVendorId());
            this.body(other.getBody());
            return this;
        }

        @Override
        @JsonSetter(value="vendor_id")
        public BodyStage vendorId(@NotNull String vendorId) {
            this.vendorId = Objects.requireNonNull(vendorId, "vendorId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="body")
        public _FinalStage body(@NotNull UpdateVendorRequest body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @Override
        public UpdateVendorsRequest build() {
            return new UpdateVendorsRequest(this.vendorId, this.body, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateVendorsRequest build();
    }

    public static interface BodyStage {
        public _FinalStage body(@NotNull UpdateVendorRequest var1);
    }

    public static interface VendorIdStage {
        public BodyStage vendorId(@NotNull String var1);

        public Builder from(UpdateVendorsRequest var1);
    }
}

