/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.WorkweekConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateWorkweekConfigResponse {
    private final Optional<WorkweekConfig> workweekConfig;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private UpdateWorkweekConfigResponse(Optional<WorkweekConfig> workweekConfig, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.workweekConfig = workweekConfig;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="workweek_config")
    public Optional<WorkweekConfig> getWorkweekConfig() {
        return this.workweekConfig;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateWorkweekConfigResponse && this.equalTo((UpdateWorkweekConfigResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateWorkweekConfigResponse other) {
        return this.workweekConfig.equals(other.workweekConfig) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.workweekConfig, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<WorkweekConfig> workweekConfig = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(UpdateWorkweekConfigResponse other) {
            this.workweekConfig(other.getWorkweekConfig());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="workweek_config", nulls=Nulls.SKIP)
        public Builder workweekConfig(Optional<WorkweekConfig> workweekConfig) {
            this.workweekConfig = workweekConfig;
            return this;
        }

        public Builder workweekConfig(WorkweekConfig workweekConfig) {
            this.workweekConfig = Optional.ofNullable(workweekConfig);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public UpdateWorkweekConfigResponse build() {
            return new UpdateWorkweekConfigResponse(this.workweekConfig, this.errors, this.additionalProperties);
        }
    }
}

