/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogIdMapping;
import com.squareup.square.types.CatalogObject;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpsertCatalogObjectResponse {
    private final Optional<List<Error>> errors;
    private final Optional<CatalogObject> catalogObject;
    private final Optional<List<CatalogIdMapping>> idMappings;
    private final Map<String, Object> additionalProperties;

    private UpsertCatalogObjectResponse(Optional<List<Error>> errors, Optional<CatalogObject> catalogObject, Optional<List<CatalogIdMapping>> idMappings, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.catalogObject = catalogObject;
        this.idMappings = idMappings;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="catalog_object")
    public Optional<CatalogObject> getCatalogObject() {
        return this.catalogObject;
    }

    @JsonProperty(value="id_mappings")
    public Optional<List<CatalogIdMapping>> getIdMappings() {
        return this.idMappings;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpsertCatalogObjectResponse && this.equalTo((UpsertCatalogObjectResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpsertCatalogObjectResponse other) {
        return this.errors.equals(other.errors) && this.catalogObject.equals(other.catalogObject) && this.idMappings.equals(other.idMappings);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.catalogObject, this.idMappings);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<CatalogObject> catalogObject = Optional.empty();
        private Optional<List<CatalogIdMapping>> idMappings = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(UpsertCatalogObjectResponse other) {
            this.errors(other.getErrors());
            this.catalogObject(other.getCatalogObject());
            this.idMappings(other.getIdMappings());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="catalog_object", nulls=Nulls.SKIP)
        public Builder catalogObject(Optional<CatalogObject> catalogObject) {
            this.catalogObject = catalogObject;
            return this;
        }

        public Builder catalogObject(CatalogObject catalogObject) {
            this.catalogObject = Optional.ofNullable(catalogObject);
            return this;
        }

        @JsonSetter(value="id_mappings", nulls=Nulls.SKIP)
        public Builder idMappings(Optional<List<CatalogIdMapping>> idMappings) {
            this.idMappings = idMappings;
            return this;
        }

        public Builder idMappings(List<CatalogIdMapping> idMappings) {
            this.idMappings = Optional.ofNullable(idMappings);
            return this;
        }

        public UpsertCatalogObjectResponse build() {
            return new UpsertCatalogObjectResponse(this.errors, this.catalogObject, this.idMappings, this.additionalProperties);
        }
    }
}

