/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Address;
import com.squareup.square.types.Error;
import com.squareup.square.types.V1Money;
import com.squareup.square.types.V1OrderHistoryEntry;
import com.squareup.square.types.V1OrderState;
import com.squareup.square.types.V1Tender;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class V1Order {
    private final Optional<List<Error>> errors;
    private final Optional<String> id;
    private final Optional<String> buyerEmail;
    private final Optional<String> recipientName;
    private final Optional<String> recipientPhoneNumber;
    private final Optional<V1OrderState> state;
    private final Optional<Address> shippingAddress;
    private final Optional<V1Money> subtotalMoney;
    private final Optional<V1Money> totalShippingMoney;
    private final Optional<V1Money> totalTaxMoney;
    private final Optional<V1Money> totalPriceMoney;
    private final Optional<V1Money> totalDiscountMoney;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Optional<String> expiresAt;
    private final Optional<String> paymentId;
    private final Optional<String> buyerNote;
    private final Optional<String> completedNote;
    private final Optional<String> refundedNote;
    private final Optional<String> canceledNote;
    private final Optional<V1Tender> tender;
    private final Optional<List<V1OrderHistoryEntry>> orderHistory;
    private final Optional<String> promoCode;
    private final Optional<String> btcReceiveAddress;
    private final Optional<Double> btcPriceSatoshi;
    private final Map<String, Object> additionalProperties;

    private V1Order(Optional<List<Error>> errors, Optional<String> id, Optional<String> buyerEmail, Optional<String> recipientName, Optional<String> recipientPhoneNumber, Optional<V1OrderState> state, Optional<Address> shippingAddress, Optional<V1Money> subtotalMoney, Optional<V1Money> totalShippingMoney, Optional<V1Money> totalTaxMoney, Optional<V1Money> totalPriceMoney, Optional<V1Money> totalDiscountMoney, Optional<String> createdAt, Optional<String> updatedAt, Optional<String> expiresAt, Optional<String> paymentId, Optional<String> buyerNote, Optional<String> completedNote, Optional<String> refundedNote, Optional<String> canceledNote, Optional<V1Tender> tender, Optional<List<V1OrderHistoryEntry>> orderHistory, Optional<String> promoCode, Optional<String> btcReceiveAddress, Optional<Double> btcPriceSatoshi, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.id = id;
        this.buyerEmail = buyerEmail;
        this.recipientName = recipientName;
        this.recipientPhoneNumber = recipientPhoneNumber;
        this.state = state;
        this.shippingAddress = shippingAddress;
        this.subtotalMoney = subtotalMoney;
        this.totalShippingMoney = totalShippingMoney;
        this.totalTaxMoney = totalTaxMoney;
        this.totalPriceMoney = totalPriceMoney;
        this.totalDiscountMoney = totalDiscountMoney;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.expiresAt = expiresAt;
        this.paymentId = paymentId;
        this.buyerNote = buyerNote;
        this.completedNote = completedNote;
        this.refundedNote = refundedNote;
        this.canceledNote = canceledNote;
        this.tender = tender;
        this.orderHistory = orderHistory;
        this.promoCode = promoCode;
        this.btcReceiveAddress = btcReceiveAddress;
        this.btcPriceSatoshi = btcPriceSatoshi;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<Error>> getErrors() {
        if (this.errors == null) {
            return Optional.empty();
        }
        return this.errors;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> getBuyerEmail() {
        if (this.buyerEmail == null) {
            return Optional.empty();
        }
        return this.buyerEmail;
    }

    @JsonIgnore
    public Optional<String> getRecipientName() {
        if (this.recipientName == null) {
            return Optional.empty();
        }
        return this.recipientName;
    }

    @JsonIgnore
    public Optional<String> getRecipientPhoneNumber() {
        if (this.recipientPhoneNumber == null) {
            return Optional.empty();
        }
        return this.recipientPhoneNumber;
    }

    @JsonProperty(value="state")
    public Optional<V1OrderState> getState() {
        return this.state;
    }

    @JsonProperty(value="shipping_address")
    public Optional<Address> getShippingAddress() {
        return this.shippingAddress;
    }

    @JsonProperty(value="subtotal_money")
    public Optional<V1Money> getSubtotalMoney() {
        return this.subtotalMoney;
    }

    @JsonProperty(value="total_shipping_money")
    public Optional<V1Money> getTotalShippingMoney() {
        return this.totalShippingMoney;
    }

    @JsonProperty(value="total_tax_money")
    public Optional<V1Money> getTotalTaxMoney() {
        return this.totalTaxMoney;
    }

    @JsonProperty(value="total_price_money")
    public Optional<V1Money> getTotalPriceMoney() {
        return this.totalPriceMoney;
    }

    @JsonProperty(value="total_discount_money")
    public Optional<V1Money> getTotalDiscountMoney() {
        return this.totalDiscountMoney;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonIgnore
    public Optional<String> getExpiresAt() {
        if (this.expiresAt == null) {
            return Optional.empty();
        }
        return this.expiresAt;
    }

    @JsonIgnore
    public Optional<String> getPaymentId() {
        if (this.paymentId == null) {
            return Optional.empty();
        }
        return this.paymentId;
    }

    @JsonIgnore
    public Optional<String> getBuyerNote() {
        if (this.buyerNote == null) {
            return Optional.empty();
        }
        return this.buyerNote;
    }

    @JsonIgnore
    public Optional<String> getCompletedNote() {
        if (this.completedNote == null) {
            return Optional.empty();
        }
        return this.completedNote;
    }

    @JsonIgnore
    public Optional<String> getRefundedNote() {
        if (this.refundedNote == null) {
            return Optional.empty();
        }
        return this.refundedNote;
    }

    @JsonIgnore
    public Optional<String> getCanceledNote() {
        if (this.canceledNote == null) {
            return Optional.empty();
        }
        return this.canceledNote;
    }

    @JsonProperty(value="tender")
    public Optional<V1Tender> getTender() {
        return this.tender;
    }

    @JsonIgnore
    public Optional<List<V1OrderHistoryEntry>> getOrderHistory() {
        if (this.orderHistory == null) {
            return Optional.empty();
        }
        return this.orderHistory;
    }

    @JsonIgnore
    public Optional<String> getPromoCode() {
        if (this.promoCode == null) {
            return Optional.empty();
        }
        return this.promoCode;
    }

    @JsonIgnore
    public Optional<String> getBtcReceiveAddress() {
        if (this.btcReceiveAddress == null) {
            return Optional.empty();
        }
        return this.btcReceiveAddress;
    }

    @JsonIgnore
    public Optional<Double> getBtcPriceSatoshi() {
        if (this.btcPriceSatoshi == null) {
            return Optional.empty();
        }
        return this.btcPriceSatoshi;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="errors")
    private Optional<List<Error>> _getErrors() {
        return this.errors;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="buyer_email")
    private Optional<String> _getBuyerEmail() {
        return this.buyerEmail;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="recipient_name")
    private Optional<String> _getRecipientName() {
        return this.recipientName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="recipient_phone_number")
    private Optional<String> _getRecipientPhoneNumber() {
        return this.recipientPhoneNumber;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="expires_at")
    private Optional<String> _getExpiresAt() {
        return this.expiresAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payment_id")
    private Optional<String> _getPaymentId() {
        return this.paymentId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="buyer_note")
    private Optional<String> _getBuyerNote() {
        return this.buyerNote;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="completed_note")
    private Optional<String> _getCompletedNote() {
        return this.completedNote;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="refunded_note")
    private Optional<String> _getRefundedNote() {
        return this.refundedNote;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="canceled_note")
    private Optional<String> _getCanceledNote() {
        return this.canceledNote;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="order_history")
    private Optional<List<V1OrderHistoryEntry>> _getOrderHistory() {
        return this.orderHistory;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="promo_code")
    private Optional<String> _getPromoCode() {
        return this.promoCode;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="btc_receive_address")
    private Optional<String> _getBtcReceiveAddress() {
        return this.btcReceiveAddress;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="btc_price_satoshi")
    private Optional<Double> _getBtcPriceSatoshi() {
        return this.btcPriceSatoshi;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof V1Order && this.equalTo((V1Order)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(V1Order other) {
        return this.errors.equals(other.errors) && this.id.equals(other.id) && this.buyerEmail.equals(other.buyerEmail) && this.recipientName.equals(other.recipientName) && this.recipientPhoneNumber.equals(other.recipientPhoneNumber) && this.state.equals(other.state) && this.shippingAddress.equals(other.shippingAddress) && this.subtotalMoney.equals(other.subtotalMoney) && this.totalShippingMoney.equals(other.totalShippingMoney) && this.totalTaxMoney.equals(other.totalTaxMoney) && this.totalPriceMoney.equals(other.totalPriceMoney) && this.totalDiscountMoney.equals(other.totalDiscountMoney) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.expiresAt.equals(other.expiresAt) && this.paymentId.equals(other.paymentId) && this.buyerNote.equals(other.buyerNote) && this.completedNote.equals(other.completedNote) && this.refundedNote.equals(other.refundedNote) && this.canceledNote.equals(other.canceledNote) && this.tender.equals(other.tender) && this.orderHistory.equals(other.orderHistory) && this.promoCode.equals(other.promoCode) && this.btcReceiveAddress.equals(other.btcReceiveAddress) && this.btcPriceSatoshi.equals(other.btcPriceSatoshi);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.id, this.buyerEmail, this.recipientName, this.recipientPhoneNumber, this.state, this.shippingAddress, this.subtotalMoney, this.totalShippingMoney, this.totalTaxMoney, this.totalPriceMoney, this.totalDiscountMoney, this.createdAt, this.updatedAt, this.expiresAt, this.paymentId, this.buyerNote, this.completedNote, this.refundedNote, this.canceledNote, this.tender, this.orderHistory, this.promoCode, this.btcReceiveAddress, this.btcPriceSatoshi);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<String> buyerEmail = Optional.empty();
        private Optional<String> recipientName = Optional.empty();
        private Optional<String> recipientPhoneNumber = Optional.empty();
        private Optional<V1OrderState> state = Optional.empty();
        private Optional<Address> shippingAddress = Optional.empty();
        private Optional<V1Money> subtotalMoney = Optional.empty();
        private Optional<V1Money> totalShippingMoney = Optional.empty();
        private Optional<V1Money> totalTaxMoney = Optional.empty();
        private Optional<V1Money> totalPriceMoney = Optional.empty();
        private Optional<V1Money> totalDiscountMoney = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<String> expiresAt = Optional.empty();
        private Optional<String> paymentId = Optional.empty();
        private Optional<String> buyerNote = Optional.empty();
        private Optional<String> completedNote = Optional.empty();
        private Optional<String> refundedNote = Optional.empty();
        private Optional<String> canceledNote = Optional.empty();
        private Optional<V1Tender> tender = Optional.empty();
        private Optional<List<V1OrderHistoryEntry>> orderHistory = Optional.empty();
        private Optional<String> promoCode = Optional.empty();
        private Optional<String> btcReceiveAddress = Optional.empty();
        private Optional<Double> btcPriceSatoshi = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(V1Order other) {
            this.errors(other.getErrors());
            this.id(other.getId());
            this.buyerEmail(other.getBuyerEmail());
            this.recipientName(other.getRecipientName());
            this.recipientPhoneNumber(other.getRecipientPhoneNumber());
            this.state(other.getState());
            this.shippingAddress(other.getShippingAddress());
            this.subtotalMoney(other.getSubtotalMoney());
            this.totalShippingMoney(other.getTotalShippingMoney());
            this.totalTaxMoney(other.getTotalTaxMoney());
            this.totalPriceMoney(other.getTotalPriceMoney());
            this.totalDiscountMoney(other.getTotalDiscountMoney());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.expiresAt(other.getExpiresAt());
            this.paymentId(other.getPaymentId());
            this.buyerNote(other.getBuyerNote());
            this.completedNote(other.getCompletedNote());
            this.refundedNote(other.getRefundedNote());
            this.canceledNote(other.getCanceledNote());
            this.tender(other.getTender());
            this.orderHistory(other.getOrderHistory());
            this.promoCode(other.getPromoCode());
            this.btcReceiveAddress(other.getBtcReceiveAddress());
            this.btcPriceSatoshi(other.getBtcPriceSatoshi());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public Builder errors(Nullable<List<Error>> errors) {
            this.errors = errors.isNull() ? null : (errors.isEmpty() ? Optional.empty() : Optional.of(errors.get()));
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="buyer_email", nulls=Nulls.SKIP)
        public Builder buyerEmail(Optional<String> buyerEmail) {
            this.buyerEmail = buyerEmail;
            return this;
        }

        public Builder buyerEmail(String buyerEmail) {
            this.buyerEmail = Optional.ofNullable(buyerEmail);
            return this;
        }

        public Builder buyerEmail(Nullable<String> buyerEmail) {
            this.buyerEmail = buyerEmail.isNull() ? null : (buyerEmail.isEmpty() ? Optional.empty() : Optional.of(buyerEmail.get()));
            return this;
        }

        @JsonSetter(value="recipient_name", nulls=Nulls.SKIP)
        public Builder recipientName(Optional<String> recipientName) {
            this.recipientName = recipientName;
            return this;
        }

        public Builder recipientName(String recipientName) {
            this.recipientName = Optional.ofNullable(recipientName);
            return this;
        }

        public Builder recipientName(Nullable<String> recipientName) {
            this.recipientName = recipientName.isNull() ? null : (recipientName.isEmpty() ? Optional.empty() : Optional.of(recipientName.get()));
            return this;
        }

        @JsonSetter(value="recipient_phone_number", nulls=Nulls.SKIP)
        public Builder recipientPhoneNumber(Optional<String> recipientPhoneNumber) {
            this.recipientPhoneNumber = recipientPhoneNumber;
            return this;
        }

        public Builder recipientPhoneNumber(String recipientPhoneNumber) {
            this.recipientPhoneNumber = Optional.ofNullable(recipientPhoneNumber);
            return this;
        }

        public Builder recipientPhoneNumber(Nullable<String> recipientPhoneNumber) {
            this.recipientPhoneNumber = recipientPhoneNumber.isNull() ? null : (recipientPhoneNumber.isEmpty() ? Optional.empty() : Optional.of(recipientPhoneNumber.get()));
            return this;
        }

        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public Builder state(Optional<V1OrderState> state) {
            this.state = state;
            return this;
        }

        public Builder state(V1OrderState state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        @JsonSetter(value="shipping_address", nulls=Nulls.SKIP)
        public Builder shippingAddress(Optional<Address> shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        public Builder shippingAddress(Address shippingAddress) {
            this.shippingAddress = Optional.ofNullable(shippingAddress);
            return this;
        }

        @JsonSetter(value="subtotal_money", nulls=Nulls.SKIP)
        public Builder subtotalMoney(Optional<V1Money> subtotalMoney) {
            this.subtotalMoney = subtotalMoney;
            return this;
        }

        public Builder subtotalMoney(V1Money subtotalMoney) {
            this.subtotalMoney = Optional.ofNullable(subtotalMoney);
            return this;
        }

        @JsonSetter(value="total_shipping_money", nulls=Nulls.SKIP)
        public Builder totalShippingMoney(Optional<V1Money> totalShippingMoney) {
            this.totalShippingMoney = totalShippingMoney;
            return this;
        }

        public Builder totalShippingMoney(V1Money totalShippingMoney) {
            this.totalShippingMoney = Optional.ofNullable(totalShippingMoney);
            return this;
        }

        @JsonSetter(value="total_tax_money", nulls=Nulls.SKIP)
        public Builder totalTaxMoney(Optional<V1Money> totalTaxMoney) {
            this.totalTaxMoney = totalTaxMoney;
            return this;
        }

        public Builder totalTaxMoney(V1Money totalTaxMoney) {
            this.totalTaxMoney = Optional.ofNullable(totalTaxMoney);
            return this;
        }

        @JsonSetter(value="total_price_money", nulls=Nulls.SKIP)
        public Builder totalPriceMoney(Optional<V1Money> totalPriceMoney) {
            this.totalPriceMoney = totalPriceMoney;
            return this;
        }

        public Builder totalPriceMoney(V1Money totalPriceMoney) {
            this.totalPriceMoney = Optional.ofNullable(totalPriceMoney);
            return this;
        }

        @JsonSetter(value="total_discount_money", nulls=Nulls.SKIP)
        public Builder totalDiscountMoney(Optional<V1Money> totalDiscountMoney) {
            this.totalDiscountMoney = totalDiscountMoney;
            return this;
        }

        public Builder totalDiscountMoney(V1Money totalDiscountMoney) {
            this.totalDiscountMoney = Optional.ofNullable(totalDiscountMoney);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="expires_at", nulls=Nulls.SKIP)
        public Builder expiresAt(Optional<String> expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public Builder expiresAt(String expiresAt) {
            this.expiresAt = Optional.ofNullable(expiresAt);
            return this;
        }

        public Builder expiresAt(Nullable<String> expiresAt) {
            this.expiresAt = expiresAt.isNull() ? null : (expiresAt.isEmpty() ? Optional.empty() : Optional.of(expiresAt.get()));
            return this;
        }

        @JsonSetter(value="payment_id", nulls=Nulls.SKIP)
        public Builder paymentId(Optional<String> paymentId) {
            this.paymentId = paymentId;
            return this;
        }

        public Builder paymentId(String paymentId) {
            this.paymentId = Optional.ofNullable(paymentId);
            return this;
        }

        public Builder paymentId(Nullable<String> paymentId) {
            this.paymentId = paymentId.isNull() ? null : (paymentId.isEmpty() ? Optional.empty() : Optional.of(paymentId.get()));
            return this;
        }

        @JsonSetter(value="buyer_note", nulls=Nulls.SKIP)
        public Builder buyerNote(Optional<String> buyerNote) {
            this.buyerNote = buyerNote;
            return this;
        }

        public Builder buyerNote(String buyerNote) {
            this.buyerNote = Optional.ofNullable(buyerNote);
            return this;
        }

        public Builder buyerNote(Nullable<String> buyerNote) {
            this.buyerNote = buyerNote.isNull() ? null : (buyerNote.isEmpty() ? Optional.empty() : Optional.of(buyerNote.get()));
            return this;
        }

        @JsonSetter(value="completed_note", nulls=Nulls.SKIP)
        public Builder completedNote(Optional<String> completedNote) {
            this.completedNote = completedNote;
            return this;
        }

        public Builder completedNote(String completedNote) {
            this.completedNote = Optional.ofNullable(completedNote);
            return this;
        }

        public Builder completedNote(Nullable<String> completedNote) {
            this.completedNote = completedNote.isNull() ? null : (completedNote.isEmpty() ? Optional.empty() : Optional.of(completedNote.get()));
            return this;
        }

        @JsonSetter(value="refunded_note", nulls=Nulls.SKIP)
        public Builder refundedNote(Optional<String> refundedNote) {
            this.refundedNote = refundedNote;
            return this;
        }

        public Builder refundedNote(String refundedNote) {
            this.refundedNote = Optional.ofNullable(refundedNote);
            return this;
        }

        public Builder refundedNote(Nullable<String> refundedNote) {
            this.refundedNote = refundedNote.isNull() ? null : (refundedNote.isEmpty() ? Optional.empty() : Optional.of(refundedNote.get()));
            return this;
        }

        @JsonSetter(value="canceled_note", nulls=Nulls.SKIP)
        public Builder canceledNote(Optional<String> canceledNote) {
            this.canceledNote = canceledNote;
            return this;
        }

        public Builder canceledNote(String canceledNote) {
            this.canceledNote = Optional.ofNullable(canceledNote);
            return this;
        }

        public Builder canceledNote(Nullable<String> canceledNote) {
            this.canceledNote = canceledNote.isNull() ? null : (canceledNote.isEmpty() ? Optional.empty() : Optional.of(canceledNote.get()));
            return this;
        }

        @JsonSetter(value="tender", nulls=Nulls.SKIP)
        public Builder tender(Optional<V1Tender> tender) {
            this.tender = tender;
            return this;
        }

        public Builder tender(V1Tender tender) {
            this.tender = Optional.ofNullable(tender);
            return this;
        }

        @JsonSetter(value="order_history", nulls=Nulls.SKIP)
        public Builder orderHistory(Optional<List<V1OrderHistoryEntry>> orderHistory) {
            this.orderHistory = orderHistory;
            return this;
        }

        public Builder orderHistory(List<V1OrderHistoryEntry> orderHistory) {
            this.orderHistory = Optional.ofNullable(orderHistory);
            return this;
        }

        public Builder orderHistory(Nullable<List<V1OrderHistoryEntry>> orderHistory) {
            this.orderHistory = orderHistory.isNull() ? null : (orderHistory.isEmpty() ? Optional.empty() : Optional.of(orderHistory.get()));
            return this;
        }

        @JsonSetter(value="promo_code", nulls=Nulls.SKIP)
        public Builder promoCode(Optional<String> promoCode) {
            this.promoCode = promoCode;
            return this;
        }

        public Builder promoCode(String promoCode) {
            this.promoCode = Optional.ofNullable(promoCode);
            return this;
        }

        public Builder promoCode(Nullable<String> promoCode) {
            this.promoCode = promoCode.isNull() ? null : (promoCode.isEmpty() ? Optional.empty() : Optional.of(promoCode.get()));
            return this;
        }

        @JsonSetter(value="btc_receive_address", nulls=Nulls.SKIP)
        public Builder btcReceiveAddress(Optional<String> btcReceiveAddress) {
            this.btcReceiveAddress = btcReceiveAddress;
            return this;
        }

        public Builder btcReceiveAddress(String btcReceiveAddress) {
            this.btcReceiveAddress = Optional.ofNullable(btcReceiveAddress);
            return this;
        }

        public Builder btcReceiveAddress(Nullable<String> btcReceiveAddress) {
            this.btcReceiveAddress = btcReceiveAddress.isNull() ? null : (btcReceiveAddress.isEmpty() ? Optional.empty() : Optional.of(btcReceiveAddress.get()));
            return this;
        }

        @JsonSetter(value="btc_price_satoshi", nulls=Nulls.SKIP)
        public Builder btcPriceSatoshi(Optional<Double> btcPriceSatoshi) {
            this.btcPriceSatoshi = btcPriceSatoshi;
            return this;
        }

        public Builder btcPriceSatoshi(Double btcPriceSatoshi) {
            this.btcPriceSatoshi = Optional.ofNullable(btcPriceSatoshi);
            return this;
        }

        public Builder btcPriceSatoshi(Nullable<Double> btcPriceSatoshi) {
            this.btcPriceSatoshi = btcPriceSatoshi.isNull() ? null : (btcPriceSatoshi.isEmpty() ? Optional.empty() : Optional.of(btcPriceSatoshi.get()));
            return this;
        }

        public V1Order build() {
            return new V1Order(this.errors, this.id, this.buyerEmail, this.recipientName, this.recipientPhoneNumber, this.state, this.shippingAddress, this.subtotalMoney, this.totalShippingMoney, this.totalTaxMoney, this.totalPriceMoney, this.totalDiscountMoney, this.createdAt, this.updatedAt, this.expiresAt, this.paymentId, this.buyerNote, this.completedNote, this.refundedNote, this.canceledNote, this.tender, this.orderHistory, this.promoCode, this.btcReceiveAddress, this.btcPriceSatoshi, this.additionalProperties);
        }
    }
}

