/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class V1RetrieveOrderRequest {
    private final String locationId;
    private final String orderId;
    private final Map<String, Object> additionalProperties;

    private V1RetrieveOrderRequest(String locationId, String orderId, Map<String, Object> additionalProperties) {
        this.locationId = locationId;
        this.orderId = orderId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonProperty(value="order_id")
    public String getOrderId() {
        return this.orderId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof V1RetrieveOrderRequest && this.equalTo((V1RetrieveOrderRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(V1RetrieveOrderRequest other) {
        return this.locationId.equals(other.locationId) && this.orderId.equals(other.orderId);
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.orderId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LocationIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LocationIdStage,
    OrderIdStage,
    _FinalStage {
        private String locationId;
        private String orderId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(V1RetrieveOrderRequest other) {
            this.locationId(other.getLocationId());
            this.orderId(other.getOrderId());
            return this;
        }

        @Override
        @JsonSetter(value="location_id")
        public OrderIdStage locationId(@NotNull String locationId) {
            this.locationId = Objects.requireNonNull(locationId, "locationId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="order_id")
        public _FinalStage orderId(@NotNull String orderId) {
            this.orderId = Objects.requireNonNull(orderId, "orderId must not be null");
            return this;
        }

        @Override
        public V1RetrieveOrderRequest build() {
            return new V1RetrieveOrderRequest(this.locationId, this.orderId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public V1RetrieveOrderRequest build();
    }

    public static interface OrderIdStage {
        public _FinalStage orderId(@NotNull String var1);
    }

    public static interface LocationIdStage {
        public OrderIdStage locationId(@NotNull String var1);

        public Builder from(V1RetrieveOrderRequest var1);
    }
}

