/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class VendorContact {
    private final Optional<String> id;
    private final Optional<String> name;
    private final Optional<String> emailAddress;
    private final Optional<String> phoneNumber;
    private final Optional<Boolean> removed;
    private final int ordinal;
    private final Map<String, Object> additionalProperties;

    private VendorContact(Optional<String> id, Optional<String> name, Optional<String> emailAddress, Optional<String> phoneNumber, Optional<Boolean> removed, int ordinal, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.emailAddress = emailAddress;
        this.phoneNumber = phoneNumber;
        this.removed = removed;
        this.ordinal = ordinal;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonIgnore
    public Optional<String> getEmailAddress() {
        if (this.emailAddress == null) {
            return Optional.empty();
        }
        return this.emailAddress;
    }

    @JsonIgnore
    public Optional<String> getPhoneNumber() {
        if (this.phoneNumber == null) {
            return Optional.empty();
        }
        return this.phoneNumber;
    }

    @JsonIgnore
    public Optional<Boolean> getRemoved() {
        if (this.removed == null) {
            return Optional.empty();
        }
        return this.removed;
    }

    @JsonProperty(value="ordinal")
    public int getOrdinal() {
        return this.ordinal;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="email_address")
    private Optional<String> _getEmailAddress() {
        return this.emailAddress;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="phone_number")
    private Optional<String> _getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="removed")
    private Optional<Boolean> _getRemoved() {
        return this.removed;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof VendorContact && this.equalTo((VendorContact)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(VendorContact other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.emailAddress.equals(other.emailAddress) && this.phoneNumber.equals(other.phoneNumber) && this.removed.equals(other.removed) && this.ordinal == other.ordinal;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.emailAddress, this.phoneNumber, this.removed, this.ordinal);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OrdinalStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OrdinalStage,
    _FinalStage {
        private int ordinal;
        private Optional<Boolean> removed = Optional.empty();
        private Optional<String> phoneNumber = Optional.empty();
        private Optional<String> emailAddress = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(VendorContact other) {
            this.id(other.getId());
            this.name(other.getName());
            this.emailAddress(other.getEmailAddress());
            this.phoneNumber(other.getPhoneNumber());
            this.removed(other.getRemoved());
            this.ordinal(other.getOrdinal());
            return this;
        }

        @Override
        @JsonSetter(value="ordinal")
        public _FinalStage ordinal(int ordinal) {
            this.ordinal = ordinal;
            return this;
        }

        @Override
        public _FinalStage removed(Nullable<Boolean> removed) {
            this.removed = removed.isNull() ? null : (removed.isEmpty() ? Optional.empty() : Optional.of(removed.get()));
            return this;
        }

        @Override
        public _FinalStage removed(Boolean removed) {
            this.removed = Optional.ofNullable(removed);
            return this;
        }

        @Override
        @JsonSetter(value="removed", nulls=Nulls.SKIP)
        public _FinalStage removed(Optional<Boolean> removed) {
            this.removed = removed;
            return this;
        }

        @Override
        public _FinalStage phoneNumber(Nullable<String> phoneNumber) {
            this.phoneNumber = phoneNumber.isNull() ? null : (phoneNumber.isEmpty() ? Optional.empty() : Optional.of(phoneNumber.get()));
            return this;
        }

        @Override
        public _FinalStage phoneNumber(String phoneNumber) {
            this.phoneNumber = Optional.ofNullable(phoneNumber);
            return this;
        }

        @Override
        @JsonSetter(value="phone_number", nulls=Nulls.SKIP)
        public _FinalStage phoneNumber(Optional<String> phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        @Override
        public _FinalStage emailAddress(Nullable<String> emailAddress) {
            this.emailAddress = emailAddress.isNull() ? null : (emailAddress.isEmpty() ? Optional.empty() : Optional.of(emailAddress.get()));
            return this;
        }

        @Override
        public _FinalStage emailAddress(String emailAddress) {
            this.emailAddress = Optional.ofNullable(emailAddress);
            return this;
        }

        @Override
        @JsonSetter(value="email_address", nulls=Nulls.SKIP)
        public _FinalStage emailAddress(Optional<String> emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @Override
        public _FinalStage name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public VendorContact build() {
            return new VendorContact(this.id, this.name, this.emailAddress, this.phoneNumber, this.removed, this.ordinal, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public VendorContact build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage name(Nullable<String> var1);

        public _FinalStage emailAddress(Optional<String> var1);

        public _FinalStage emailAddress(String var1);

        public _FinalStage emailAddress(Nullable<String> var1);

        public _FinalStage phoneNumber(Optional<String> var1);

        public _FinalStage phoneNumber(String var1);

        public _FinalStage phoneNumber(Nullable<String> var1);

        public _FinalStage removed(Optional<Boolean> var1);

        public _FinalStage removed(Boolean var1);

        public _FinalStage removed(Nullable<Boolean> var1);
    }

    public static interface OrdinalStage {
        public _FinalStage ordinal(int var1);

        public Builder from(VendorContact var1);
    }
}

