/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.JobAssignment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class WageSetting {
    private final Optional<String> teamMemberId;
    private final Optional<List<JobAssignment>> jobAssignments;
    private final Optional<Boolean> isOvertimeExempt;
    private final Optional<Integer> version;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Map<String, Object> additionalProperties;

    private WageSetting(Optional<String> teamMemberId, Optional<List<JobAssignment>> jobAssignments, Optional<Boolean> isOvertimeExempt, Optional<Integer> version, Optional<String> createdAt, Optional<String> updatedAt, Map<String, Object> additionalProperties) {
        this.teamMemberId = teamMemberId;
        this.jobAssignments = jobAssignments;
        this.isOvertimeExempt = isOvertimeExempt;
        this.version = version;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getTeamMemberId() {
        if (this.teamMemberId == null) {
            return Optional.empty();
        }
        return this.teamMemberId;
    }

    @JsonIgnore
    public Optional<List<JobAssignment>> getJobAssignments() {
        if (this.jobAssignments == null) {
            return Optional.empty();
        }
        return this.jobAssignments;
    }

    @JsonIgnore
    public Optional<Boolean> getIsOvertimeExempt() {
        if (this.isOvertimeExempt == null) {
            return Optional.empty();
        }
        return this.isOvertimeExempt;
    }

    @JsonProperty(value="version")
    public Optional<Integer> getVersion() {
        return this.version;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="team_member_id")
    private Optional<String> _getTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="job_assignments")
    private Optional<List<JobAssignment>> _getJobAssignments() {
        return this.jobAssignments;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="is_overtime_exempt")
    private Optional<Boolean> _getIsOvertimeExempt() {
        return this.isOvertimeExempt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof WageSetting && this.equalTo((WageSetting)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(WageSetting other) {
        return this.teamMemberId.equals(other.teamMemberId) && this.jobAssignments.equals(other.jobAssignments) && this.isOvertimeExempt.equals(other.isOvertimeExempt) && this.version.equals(other.version) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.teamMemberId, this.jobAssignments, this.isOvertimeExempt, this.version, this.createdAt, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> teamMemberId = Optional.empty();
        private Optional<List<JobAssignment>> jobAssignments = Optional.empty();
        private Optional<Boolean> isOvertimeExempt = Optional.empty();
        private Optional<Integer> version = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(WageSetting other) {
            this.teamMemberId(other.getTeamMemberId());
            this.jobAssignments(other.getJobAssignments());
            this.isOvertimeExempt(other.getIsOvertimeExempt());
            this.version(other.getVersion());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @JsonSetter(value="team_member_id", nulls=Nulls.SKIP)
        public Builder teamMemberId(Optional<String> teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = Optional.ofNullable(teamMemberId);
            return this;
        }

        public Builder teamMemberId(Nullable<String> teamMemberId) {
            this.teamMemberId = teamMemberId.isNull() ? null : (teamMemberId.isEmpty() ? Optional.empty() : Optional.of(teamMemberId.get()));
            return this;
        }

        @JsonSetter(value="job_assignments", nulls=Nulls.SKIP)
        public Builder jobAssignments(Optional<List<JobAssignment>> jobAssignments) {
            this.jobAssignments = jobAssignments;
            return this;
        }

        public Builder jobAssignments(List<JobAssignment> jobAssignments) {
            this.jobAssignments = Optional.ofNullable(jobAssignments);
            return this;
        }

        public Builder jobAssignments(Nullable<List<JobAssignment>> jobAssignments) {
            this.jobAssignments = jobAssignments.isNull() ? null : (jobAssignments.isEmpty() ? Optional.empty() : Optional.of(jobAssignments.get()));
            return this;
        }

        @JsonSetter(value="is_overtime_exempt", nulls=Nulls.SKIP)
        public Builder isOvertimeExempt(Optional<Boolean> isOvertimeExempt) {
            this.isOvertimeExempt = isOvertimeExempt;
            return this;
        }

        public Builder isOvertimeExempt(Boolean isOvertimeExempt) {
            this.isOvertimeExempt = Optional.ofNullable(isOvertimeExempt);
            return this;
        }

        public Builder isOvertimeExempt(Nullable<Boolean> isOvertimeExempt) {
            this.isOvertimeExempt = isOvertimeExempt.isNull() ? null : (isOvertimeExempt.isEmpty() ? Optional.empty() : Optional.of(isOvertimeExempt.get()));
            return this;
        }

        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public Builder version(Optional<Integer> version) {
            this.version = version;
            return this;
        }

        public Builder version(Integer version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        public WageSetting build() {
            return new WageSetting(this.teamMemberId, this.jobAssignments, this.isOvertimeExempt, this.version, this.createdAt, this.updatedAt, this.additionalProperties);
        }
    }
}

