/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.webhooks;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.CreateWebhookSubscriptionResponse;
import com.squareup.square.types.DeleteWebhookSubscriptionResponse;
import com.squareup.square.types.GetWebhookSubscriptionResponse;
import com.squareup.square.types.TestWebhookSubscriptionResponse;
import com.squareup.square.types.UpdateWebhookSubscriptionResponse;
import com.squareup.square.types.UpdateWebhookSubscriptionSignatureKeyResponse;
import com.squareup.square.types.WebhookSubscription;
import com.squareup.square.webhooks.RawSubscriptionsClient;
import com.squareup.square.webhooks.types.CreateWebhookSubscriptionRequest;
import com.squareup.square.webhooks.types.DeleteSubscriptionsRequest;
import com.squareup.square.webhooks.types.GetSubscriptionsRequest;
import com.squareup.square.webhooks.types.ListSubscriptionsRequest;
import com.squareup.square.webhooks.types.TestWebhookSubscriptionRequest;
import com.squareup.square.webhooks.types.UpdateWebhookSubscriptionRequest;
import com.squareup.square.webhooks.types.UpdateWebhookSubscriptionSignatureKeyRequest;

public class SubscriptionsClient {
    protected final ClientOptions clientOptions;
    private final RawSubscriptionsClient rawClient;

    public SubscriptionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawSubscriptionsClient(clientOptions);
    }

    public RawSubscriptionsClient withRawResponse() {
        return this.rawClient;
    }

    public SyncPagingIterable<WebhookSubscription> list() {
        return this.rawClient.list().body();
    }

    public SyncPagingIterable<WebhookSubscription> list(ListSubscriptionsRequest request) {
        return this.rawClient.list(request).body();
    }

    public SyncPagingIterable<WebhookSubscription> list(ListSubscriptionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).body();
    }

    public CreateWebhookSubscriptionResponse create(CreateWebhookSubscriptionRequest request) {
        return this.rawClient.create(request).body();
    }

    public CreateWebhookSubscriptionResponse create(CreateWebhookSubscriptionRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    public GetWebhookSubscriptionResponse get(GetSubscriptionsRequest request) {
        return this.rawClient.get(request).body();
    }

    public GetWebhookSubscriptionResponse get(GetSubscriptionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).body();
    }

    public UpdateWebhookSubscriptionResponse update(UpdateWebhookSubscriptionRequest request) {
        return this.rawClient.update(request).body();
    }

    public UpdateWebhookSubscriptionResponse update(UpdateWebhookSubscriptionRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).body();
    }

    public DeleteWebhookSubscriptionResponse delete(DeleteSubscriptionsRequest request) {
        return this.rawClient.delete(request).body();
    }

    public DeleteWebhookSubscriptionResponse delete(DeleteSubscriptionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).body();
    }

    public UpdateWebhookSubscriptionSignatureKeyResponse updateSignatureKey(UpdateWebhookSubscriptionSignatureKeyRequest request) {
        return this.rawClient.updateSignatureKey(request).body();
    }

    public UpdateWebhookSubscriptionSignatureKeyResponse updateSignatureKey(UpdateWebhookSubscriptionSignatureKeyRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateSignatureKey(request, requestOptions).body();
    }

    public TestWebhookSubscriptionResponse test(TestWebhookSubscriptionRequest request) {
        return this.rawClient.test(request).body();
    }

    public TestWebhookSubscriptionResponse test(TestWebhookSubscriptionRequest request, RequestOptions requestOptions) {
        return this.rawClient.test(request, requestOptions).body();
    }
}

