/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.webhooks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.WebhookSubscription;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateWebhookSubscriptionRequest {
    private final Optional<String> idempotencyKey;
    private final WebhookSubscription subscription;
    private final Map<String, Object> additionalProperties;

    private CreateWebhookSubscriptionRequest(Optional<String> idempotencyKey, WebhookSubscription subscription, Map<String, Object> additionalProperties) {
        this.idempotencyKey = idempotencyKey;
        this.subscription = subscription;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="idempotency_key")
    public Optional<String> getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="subscription")
    public WebhookSubscription getSubscription() {
        return this.subscription;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateWebhookSubscriptionRequest && this.equalTo((CreateWebhookSubscriptionRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateWebhookSubscriptionRequest other) {
        return this.idempotencyKey.equals(other.idempotencyKey) && this.subscription.equals(other.subscription);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.subscription);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SubscriptionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SubscriptionStage,
    _FinalStage {
        private WebhookSubscription subscription;
        private Optional<String> idempotencyKey = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateWebhookSubscriptionRequest other) {
            this.idempotencyKey(other.getIdempotencyKey());
            this.subscription(other.getSubscription());
            return this;
        }

        @Override
        @JsonSetter(value="subscription")
        public _FinalStage subscription(@NotNull WebhookSubscription subscription) {
            this.subscription = Objects.requireNonNull(subscription, "subscription must not be null");
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = Optional.ofNullable(idempotencyKey);
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key", nulls=Nulls.SKIP)
        public _FinalStage idempotencyKey(Optional<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        @Override
        public CreateWebhookSubscriptionRequest build() {
            return new CreateWebhookSubscriptionRequest(this.idempotencyKey, this.subscription, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateWebhookSubscriptionRequest build();

        public _FinalStage idempotencyKey(Optional<String> var1);

        public _FinalStage idempotencyKey(String var1);
    }

    public static interface SubscriptionStage {
        public _FinalStage subscription(@NotNull WebhookSubscription var1);

        public Builder from(CreateWebhookSubscriptionRequest var1);
    }
}

