/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.ConsoleWireLogger;
import com.squareup.wire.WireLogger;
import com.squareup.wire.schema.ClaimedDefinitions;
import com.squareup.wire.schema.EmittingRules;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.NewSchemaLoader;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.PruningRules;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Target;
import com.squareup.wire.schema.WireRun;
import java.io.Closeable;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0018\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001Bs\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003H\u00c6\u0003J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u000eH\u00c6\u0003J{\u0010#\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00072\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00032\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010$\u001a\u00020\u000e2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u001a\u0010&\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020+J \u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\t\u0010.\u001a\u00020/H\u00d6\u0001J\t\u00100\u001a\u00020\u0007H\u00d6\u0001J\u0018\u00101\u001a\u0002022\u0006\u00103\u001a\u0002022\u0006\u0010*\u001a\u00020+H\u0002R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015\u00a8\u00064"}, d2={"Lcom/squareup/wire/schema/WireRun;", "", "sourcePath", "", "Lcom/squareup/wire/schema/Location;", "protoPath", "treeShakingRoots", "", "treeShakingRubbish", "since", "until", "targets", "Lcom/squareup/wire/schema/Target;", "proto3Preview", "", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Z)V", "getProto3Preview", "()Z", "getProtoPath", "()Ljava/util/List;", "getSince", "()Ljava/lang/String;", "getSourcePath", "getTargets", "getTreeShakingRoots", "getTreeShakingRubbish", "getUntil", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "execute", "", "fs", "Ljava/nio/file/FileSystem;", "logger", "Lcom/squareup/wire/WireLogger;", "schemaLoader", "Lcom/squareup/wire/schema/NewSchemaLoader;", "hashCode", "", "toString", "treeShake", "Lcom/squareup/wire/schema/Schema;", "schema", "wire-compiler"})
public final class WireRun {
    @NotNull
    private final List<Location> sourcePath;
    @NotNull
    private final List<Location> protoPath;
    @NotNull
    private final List<String> treeShakingRoots;
    @NotNull
    private final List<String> treeShakingRubbish;
    @Nullable
    private final String since;
    @Nullable
    private final String until;
    @NotNull
    private final List<Target> targets;
    private final boolean proto3Preview;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(@NotNull FileSystem fs, @NotNull WireLogger logger) {
        Intrinsics.checkParameterIsNotNull((Object)fs, (String)"fs");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Closeable closeable = new NewSchemaLoader(fs);
        boolean bl = false;
        Throwable throwable = null;
        try {
            NewSchemaLoader newSchemaLoader = (NewSchemaLoader)closeable;
            boolean bl2 = false;
            this.execute(fs, logger, newSchemaLoader);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void execute$default(WireRun wireRun, FileSystem fileSystem, WireLogger wireLogger, int n, Object object) {
        if ((n & 1) != 0) {
            FileSystem fileSystem2 = FileSystems.getDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileSystem2, (String)"FileSystems.getDefault()");
            fileSystem = fileSystem2;
        }
        if ((n & 2) != 0) {
            wireLogger = new ConsoleWireLogger();
        }
        wireRun.execute(fileSystem, wireLogger);
    }

    /*
     * WARNING - void declaration
     */
    private final void execute(FileSystem fs, WireLogger logger, NewSchemaLoader schemaLoader) {
        String string;
        Comparator it3;
        Object object;
        void $this$mapTo$iv$iv;
        schemaLoader.initRoots(this.sourcePath, this.protoPath);
        Schema fullSchema = schemaLoader.loadSchema();
        Iterable $this$map$iv = schemaLoader.getSourcePathFiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ProtoFile protoFile = (ProtoFile)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            string = it3.getLocation().getPath();
            object.add(string);
        }
        List sourceLocationPaths = (List)destination$iv$iv;
        Schema schema = this.treeShake(fullSchema, logger);
        Iterable $this$associateWith$iv = this.targets;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo2 = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it2;
            Target target = (Target)element$iv$iv;
            string = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            EmittingRules emittingRules = new EmittingRules.Builder().include((Iterable)it2.getIncludes()).exclude((Iterable)it2.getExcludes()).build();
            object.put(string, emittingRules);
        }
        Map targetToEmittingRules = result$iv;
        Iterable $this$sortedBy$iv = this.targets;
        boolean $i$f$sortedBy = false;
        Iterator<Object> iterator = $this$sortedBy$iv;
        $i$f$associateWithTo2 = false;
        it3 = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Target it = (Target)a;
                boolean bl2 = false;
                Comparable comparable = Boolean.valueOf(it.getExclusive());
                it = (Target)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Boolean bl3 = it.getExclusive();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)bl3);
            }
        };
        List targetsExclusiveLast = CollectionsKt.sortedWith((Iterable)((Object)iterator), (Comparator)it3);
        $i$f$sortedBy = false;
        List skippedForSyntax = new ArrayList();
        for (ProtoFile protoFile : schema.getProtoFiles()) {
            if (protoFile.getSyntax() == ProtoFile.Syntax.PROTO_3 && !this.proto3Preview) {
                Collection $i$f$associateWithTo2 = skippedForSyntax;
                boolean it3 = false;
                $i$f$associateWithTo2.add(protoFile);
                continue;
            }
            if (!sourceLocationPaths.contains(protoFile.getLocation().getPath())) continue;
            ClaimedDefinitions claimedDefinitions = new ClaimedDefinitions();
            claimedDefinitions.claim(ProtoType.ANY);
            for (Target target : targetsExclusiveLast) {
                Target.SchemaHandler schemaHandler = target.newHandler$wire_compiler(schema, fs, logger, schemaLoader);
                Object v = targetToEmittingRules.get(target);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                schemaHandler.handle(protoFile, (EmittingRules)v, claimedDefinitions, target.getExclusive());
            }
        }
        for (EmittingRules emittingRules : targetToEmittingRules.values()) {
            Collection collection = emittingRules.unusedIncludes();
            boolean bl = false;
            if (!collection.isEmpty()) {
                logger.info(StringsKt.trimMargin$default((String)("Unused includes in targets:\n            |  " + CollectionsKt.joinToString$default((Iterable)emittingRules.unusedIncludes(), (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null) + "\n            "), null, (int)1, null));
            }
            collection = emittingRules.unusedExcludes();
            bl = false;
            if (!(!collection.isEmpty())) continue;
            logger.info(StringsKt.trimMargin$default((String)("Unused excludes in targets:\n            |  " + CollectionsKt.joinToString$default((Iterable)emittingRules.unusedExcludes(), (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null) + "\n            "), null, (int)1, null));
        }
        Collection collection = skippedForSyntax;
        boolean bl = false;
        if (!collection.isEmpty()) {
            logger.info(StringsKt.trimMargin$default((String)("Skipped .proto files with unsupported syntax. Add this line to fix:\n          |  syntax = \"proto2\";\n          |  " + CollectionsKt.joinToString$default((Iterable)skippedForSyntax, (CharSequence)"\n  ", null, null, (int)0, null, (Function1)execute.2.INSTANCE, (int)30, null) + "\n          "), null, (int)1, null));
        }
    }

    private final Schema treeShake(Schema schema, WireLogger logger) {
        if (Intrinsics.areEqual(this.treeShakingRoots, (Object)CollectionsKt.listOf((Object)"*")) && this.treeShakingRubbish.isEmpty() && this.since == null && this.until == null) {
            return schema;
        }
        PruningRules pruningRules = new PruningRules.Builder().addRoot((Iterable)this.treeShakingRoots).prune((Iterable)this.treeShakingRubbish).since(this.since).until(this.until).build();
        Schema result = schema.prune(pruningRules);
        for (String rule : pruningRules.unusedRoots()) {
            logger.info("Unused element in treeShakingRoots: " + rule);
        }
        for (String rule : pruningRules.unusedPrunes()) {
            logger.info("Unused element in treeShakingRubbish: " + rule);
        }
        return result;
    }

    @NotNull
    public final List<Location> getSourcePath() {
        return this.sourcePath;
    }

    @NotNull
    public final List<Location> getProtoPath() {
        return this.protoPath;
    }

    @NotNull
    public final List<String> getTreeShakingRoots() {
        return this.treeShakingRoots;
    }

    @NotNull
    public final List<String> getTreeShakingRubbish() {
        return this.treeShakingRubbish;
    }

    @Nullable
    public final String getSince() {
        return this.since;
    }

    @Nullable
    public final String getUntil() {
        return this.until;
    }

    @NotNull
    public final List<Target> getTargets() {
        return this.targets;
    }

    public final boolean getProto3Preview() {
        return this.proto3Preview;
    }

    public WireRun(@NotNull List<Location> sourcePath, @NotNull List<Location> protoPath, @NotNull List<String> treeShakingRoots, @NotNull List<String> treeShakingRubbish, @Nullable String since, @Nullable String until, @NotNull List<? extends Target> targets, boolean proto3Preview) {
        Intrinsics.checkParameterIsNotNull(sourcePath, (String)"sourcePath");
        Intrinsics.checkParameterIsNotNull(protoPath, (String)"protoPath");
        Intrinsics.checkParameterIsNotNull(treeShakingRoots, (String)"treeShakingRoots");
        Intrinsics.checkParameterIsNotNull(treeShakingRubbish, (String)"treeShakingRubbish");
        Intrinsics.checkParameterIsNotNull(targets, (String)"targets");
        this.sourcePath = sourcePath;
        this.protoPath = protoPath;
        this.treeShakingRoots = treeShakingRoots;
        this.treeShakingRubbish = treeShakingRubbish;
        this.since = since;
        this.until = until;
        this.targets = targets;
        this.proto3Preview = proto3Preview;
    }

    public /* synthetic */ WireRun(List list, List list2, List list3, List list4, String string, String string2, List list5, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        boolean bl2;
        if ((n & 2) != 0) {
            bl2 = false;
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list3 = CollectionsKt.listOf((Object)"*");
        }
        if ((n & 8) != 0) {
            bl2 = false;
            list4 = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            string = null;
        }
        if ((n & 0x20) != 0) {
            string2 = null;
        }
        if ((n & 0x80) != 0) {
            bl = false;
        }
        this(list, list2, list3, list4, string, string2, list5, bl);
    }

    @NotNull
    public final List<Location> component1() {
        return this.sourcePath;
    }

    @NotNull
    public final List<Location> component2() {
        return this.protoPath;
    }

    @NotNull
    public final List<String> component3() {
        return this.treeShakingRoots;
    }

    @NotNull
    public final List<String> component4() {
        return this.treeShakingRubbish;
    }

    @Nullable
    public final String component5() {
        return this.since;
    }

    @Nullable
    public final String component6() {
        return this.until;
    }

    @NotNull
    public final List<Target> component7() {
        return this.targets;
    }

    public final boolean component8() {
        return this.proto3Preview;
    }

    @NotNull
    public final WireRun copy(@NotNull List<Location> sourcePath, @NotNull List<Location> protoPath, @NotNull List<String> treeShakingRoots, @NotNull List<String> treeShakingRubbish, @Nullable String since, @Nullable String until, @NotNull List<? extends Target> targets, boolean proto3Preview) {
        Intrinsics.checkParameterIsNotNull(sourcePath, (String)"sourcePath");
        Intrinsics.checkParameterIsNotNull(protoPath, (String)"protoPath");
        Intrinsics.checkParameterIsNotNull(treeShakingRoots, (String)"treeShakingRoots");
        Intrinsics.checkParameterIsNotNull(treeShakingRubbish, (String)"treeShakingRubbish");
        Intrinsics.checkParameterIsNotNull(targets, (String)"targets");
        return new WireRun(sourcePath, protoPath, treeShakingRoots, treeShakingRubbish, since, until, targets, proto3Preview);
    }

    public static /* synthetic */ WireRun copy$default(WireRun wireRun, List list, List list2, List list3, List list4, String string, String string2, List list5, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            list = wireRun.sourcePath;
        }
        if ((n & 2) != 0) {
            list2 = wireRun.protoPath;
        }
        if ((n & 4) != 0) {
            list3 = wireRun.treeShakingRoots;
        }
        if ((n & 8) != 0) {
            list4 = wireRun.treeShakingRubbish;
        }
        if ((n & 0x10) != 0) {
            string = wireRun.since;
        }
        if ((n & 0x20) != 0) {
            string2 = wireRun.until;
        }
        if ((n & 0x40) != 0) {
            list5 = wireRun.targets;
        }
        if ((n & 0x80) != 0) {
            bl = wireRun.proto3Preview;
        }
        return wireRun.copy(list, list2, list3, list4, string, string2, list5, bl);
    }

    @NotNull
    public String toString() {
        return "WireRun(sourcePath=" + this.sourcePath + ", protoPath=" + this.protoPath + ", treeShakingRoots=" + this.treeShakingRoots + ", treeShakingRubbish=" + this.treeShakingRubbish + ", since=" + this.since + ", until=" + this.until + ", targets=" + this.targets + ", proto3Preview=" + this.proto3Preview + ")";
    }

    public int hashCode() {
        List<Location> list = this.sourcePath;
        List<Location> list2 = this.protoPath;
        List<String> list3 = this.treeShakingRoots;
        List<String> list4 = this.treeShakingRubbish;
        String string = this.since;
        String string2 = this.until;
        List<Target> list5 = this.targets;
        int n = (((((((list != null ? ((Object)list).hashCode() : 0) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31 + (list3 != null ? ((Object)list3).hashCode() : 0)) * 31 + (list4 != null ? ((Object)list4).hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (list5 != null ? ((Object)list5).hashCode() : 0)) * 31;
        int n2 = this.proto3Preview ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        return n + n2;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof WireRun)) break block3;
                WireRun wireRun = (WireRun)object;
                if (!Intrinsics.areEqual(this.sourcePath, wireRun.sourcePath) || !Intrinsics.areEqual(this.protoPath, wireRun.protoPath) || !Intrinsics.areEqual(this.treeShakingRoots, wireRun.treeShakingRoots) || !Intrinsics.areEqual(this.treeShakingRubbish, wireRun.treeShakingRubbish) || !Intrinsics.areEqual((Object)this.since, (Object)wireRun.since) || !Intrinsics.areEqual((Object)this.until, (Object)wireRun.until) || !Intrinsics.areEqual(this.targets, wireRun.targets) || this.proto3Preview != wireRun.proto3Preview) break block3;
            }
            return true;
        }
        return false;
    }
}

