/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.gradle.internal;

import com.squareup.javapoet.JavaFile;
import com.squareup.kotlinpoet.TypeSpec;
import com.squareup.wire.WireLogger;
import com.squareup.wire.gradle.WirePlugin;
import com.squareup.wire.schema.ProtoType;
import io.outfoxx.swiftpoet.FileSpec;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0013H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/squareup/wire/gradle/internal/GradleWireLogger;", "Lcom/squareup/wire/WireLogger;", "()V", "slf4jLogger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "artifact", "", "outputPath", "Lokio/Path;", "javaFile", "Lcom/squareup/javapoet/JavaFile;", "kotlinFile", "Lcom/squareup/kotlinpoet/FileSpec;", "type", "Lcom/squareup/wire/schema/ProtoType;", "swiftFile", "Lio/outfoxx/swiftpoet/FileSpec;", "filePath", "", "artifactSkipped", "setQuiet", "quiet", "", "warn", "message", "wire-gradle-plugin"})
public final class GradleWireLogger
implements WireLogger {
    @NotNull
    public static final GradleWireLogger INSTANCE = new GradleWireLogger();
    private static final Logger slf4jLogger = LoggerFactory.getLogger(WirePlugin.class);

    private GradleWireLogger() {
    }

    public void setQuiet(boolean quiet) {
    }

    public void warn(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        slf4jLogger.warn(message);
    }

    public void artifact(@NotNull Path outputPath, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        slf4jLogger.info("Writing " + filePath + " to " + outputPath);
    }

    public void artifact(@NotNull Path outputPath, @NotNull JavaFile javaFile) {
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter((Object)javaFile, (String)"javaFile");
        slf4jLogger.info("Writing " + javaFile.packageName + '.' + javaFile.typeSpec.name + " to " + outputPath);
    }

    public void artifact(@NotNull Path outputPath, @NotNull com.squareup.kotlinpoet.FileSpec kotlinFile) {
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter((Object)kotlinFile, (String)"kotlinFile");
        TypeSpec typeSpec = (TypeSpec)CollectionsKt.first((List)kotlinFile.getMembers());
        slf4jLogger.info("Writing " + kotlinFile.getPackageName() + '.' + typeSpec.getName() + " to " + outputPath);
    }

    public void artifact(@NotNull Path outputPath, @NotNull ProtoType type, @NotNull FileSpec swiftFile) {
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)swiftFile, (String)"swiftFile");
        slf4jLogger.info("Writing " + type + " to " + outputPath);
    }

    public void artifactSkipped(@NotNull ProtoType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        slf4jLogger.info(Intrinsics.stringPlus((String)"Skipping ", (Object)type));
    }
}

