//[wire-compiler](../../../index.md)/[com.squareup.wire](../index.md)/[WireCompiler](index.md)

# WireCompiler

[jvm]\
class [WireCompiler](index.md)

Command line interface to the Wire Java generator.

Usage

 -----

java WireCompiler --proto_path=&lt;path&gt;\
  [--java_out=&lt;path&gt;]\
  [--kotlin_out=&lt;path&gt;]\
  [--swift_out=&lt;path&gt;]\
  [--custom_out=&lt;path&gt;]\
  [--schema_handler_factory_class=&lt;class_name&gt;]\
  [--files=&lt;protos.include&gt;]\
  [--includes=&lt;message_name&gt;[,&lt;message_name&gt;...]]\
  [--excludes=&lt;message_name&gt;[,&lt;message_name&gt;...]]\
  [--android]\
  [--android-annotations]\
  [--compact]\
  [file [file...]]

--java_out should provide the folder where the files generated by the Java code generator should be placed. Similarly, --kotlin_out should provide the folder where the files generated by the Kotlin code generator will be written. Only one of the two should be specified.

--swift_out should provide the folder where the files generated by the Swift code generator should be placed.

--schema_handler_factory_class should be used if you want a custom SchemaHandler to be called. The factory class itself should be included in your classpath. If set, custom_out should also be provided and will passed to the factory's handler as a location to where it will be able to write files.

If the --includes flag is present, its argument must be a comma-separated list of fully-qualified message or enum names. The output will be limited to those messages and enums that are (transitive) dependencies of the listed names. The --excludes flag excludes types, and takes precedence over --includes.

If the --registry_class flag is present, its argument must be a Java class name. A class with the given name will be generated, containing a constant list of all extension classes generated during the compile. This list is suitable for passing to Wire's constructor at runtime for constructing its internal extension registry.

The --dry_run flag causes the compile to just emit the names of the source files that would be generated to stdout.

The --android flag will cause all messages to implement the Parcelable interface. This implies --android-annotations as well.

The --android-annotations flag will add the Nullable annotation to optional fields.

The --compact flag will emit code that uses reflection for reading, writing, and toString methods which are normally implemented with code generation.

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [compile](compile.md) | [jvm]<br>fun [compile](compile.md)() |

## Properties

| Name | Summary |
|---|---|
| [customOut](custom-out.md) | [jvm]<br>val [customOut](custom-out.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |
| [emitAndroid](emit-android.md) | [jvm]<br>val [emitAndroid](emit-android.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [emitAndroidAnnotations](emit-android-annotations.md) | [jvm]<br>val [emitAndroidAnnotations](emit-android-annotations.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [emitAppliedOptions](emit-applied-options.md) | [jvm]<br>val [emitAppliedOptions](emit-applied-options.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [emitCompact](emit-compact.md) | [jvm]<br>val [emitCompact](emit-compact.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [emitDeclaredOptions](emit-declared-options.md) | [jvm]<br>val [emitDeclaredOptions](emit-declared-options.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [fs](fs.md) | [jvm]<br>val [fs](fs.md): FileSystem |
| [javaInterop](java-interop.md) | [jvm]<br>val [javaInterop](java-interop.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [javaOut](java-out.md) | [jvm]<br>val [javaOut](java-out.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |
| [kotlinBoxOneOfsMinSize](kotlin-box-one-ofs-min-size.md) | [jvm]<br>val [kotlinBoxOneOfsMinSize](kotlin-box-one-ofs-min-size.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [kotlinOut](kotlin-out.md) | [jvm]<br>val [kotlinOut](kotlin-out.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |
| [log](log.md) | [jvm]<br>val [log](log.md): WireLogger |
| [modules](modules.md) | [jvm]<br>val [modules](modules.md): [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [WireRun.Module](../../com.squareup.wire.schema/-wire-run/-module/index.md)&gt; |
| [permitPackageCycles](permit-package-cycles.md) | [jvm]<br>val [permitPackageCycles](permit-package-cycles.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [protoPaths](proto-paths.md) | [jvm]<br>val [protoPaths](proto-paths.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt; |
| [schemaHandlerFactoryClass](schema-handler-factory-class.md) | [jvm]<br>val [schemaHandlerFactoryClass](schema-handler-factory-class.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |
| [sourceFileNames](source-file-names.md) | [jvm]<br>val [sourceFileNames](source-file-names.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt; |
| [swiftOut](swift-out.md) | [jvm]<br>val [swiftOut](swift-out.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |
| [treeShakingRoots](tree-shaking-roots.md) | [jvm]<br>val [treeShakingRoots](tree-shaking-roots.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt; |
| [treeShakingRubbish](tree-shaking-rubbish.md) | [jvm]<br>val [treeShakingRubbish](tree-shaking-rubbish.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt; |
