/*
 * Copyright (C) 2019 Square, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.squareup.wire.internal

import okhttp3.MediaType
import okhttp3.RequestBody
import okio.BufferedSink
import okio.Pipe
import okio.buffer

/**
 * A duplex request body that provides early writes via a pipe.
 */
internal class PipeDuplexRequestBody(
  private val contentType: MediaType?,
  pipeMaxBufferSize: Long,
) : RequestBody() {
  private val pipe = Pipe(pipeMaxBufferSize)

  fun createSink() = pipe.sink.buffer()

  override fun contentType() = contentType

  override fun writeTo(sink: BufferedSink) {
    pipe.fold(sink)
  }

  override fun isDuplex() = true

  /** [Pipe.fold] can only be called once. */
  override fun isOneShot() = true
}
