[wire-grpc-client](../../index.md) / [com.squareup.wire](../index.md) / [GrpcCall](./index.md)

# GrpcCall

`interface GrpcCall<S : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, R : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>`

A single call to a remote server. This call sends a single request value and receives a single
response value. A gRPC call cannot be executed twice.

gRPC calls can be [suspending](execute.md), [blocking](execute-blocking.md), or
[asynchronous](enqueue.md). Use whichever mechanism works at your call site: the bytes transmitted
on the network are the same.

### Types

| Name | Summary |
|---|---|
| [Callback](-callback/index.md) | `interface Callback<S : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, R : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>` |

### Properties

| Name | Summary |
|---|---|
| [timeout](timeout.md) | `abstract val timeout: <ERROR CLASS>`<br>Configures how long the call can take to complete before it is automatically canceled. |

### Functions

| Name | Summary |
|---|---|
| [cancel](cancel.md) | `abstract fun cancel(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Attempts to cancel the call. This function is safe to call concurrently with execution. When canceled, execution fails with an immediate [IOException](#) rather than waiting to complete normally. |
| [clone](clone.md) | `abstract fun clone(): `[`GrpcCall`](./index.md)`<`[`S`](index.md#S)`, `[`R`](index.md#R)`>`<br>Create a new, identical gRPC call to this one which can be enqueued or executed even if this call has already been. |
| [enqueue](enqueue.md) | `abstract fun enqueue(request: `[`S`](index.md#S)`, callback: `[`Callback`](-callback/index.md)`<`[`S`](index.md#S)`, `[`R`](index.md#R)`>): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Enqueues this call for asynchronous execution. The [callback](enqueue.md#com.squareup.wire.GrpcCall$enqueue(com.squareup.wire.GrpcCall.S, com.squareup.wire.GrpcCall.Callback((com.squareup.wire.GrpcCall.S, com.squareup.wire.GrpcCall.R)))/callback) will be invoked on the client's dispatcher thread when the call completes. |
| [execute](execute.md) | `abstract suspend fun execute(request: `[`S`](index.md#S)`): `[`R`](index.md#R)<br>Invokes the call immediately and suspends until its response is received. |
| [executeBlocking](execute-blocking.md) | `abstract fun executeBlocking(request: `[`S`](index.md#S)`): `[`R`](index.md#R)<br>Invokes the call immediately and blocks until its response is received. |
| [isCanceled](is-canceled.md) | `abstract fun isCanceled(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>True if [cancel](cancel.md) was called. |
| [isExecuted](is-executed.md) | `abstract fun isExecuted(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if [execute](execute.md), [executeBlocking](execute-blocking.md), or [enqueue](enqueue.md) was called. It is an error to execute or enqueue a call more than once. |
