[wire-runtime](../index.md) / [com.squareup.wire](./index.md)

## Package com.squareup.wire

### Types

| Name | Summary |
|---|---|
| [AndroidMessage](-android-message/index.md)<br>(JVM) | `abstract class AndroidMessage<M : `[`Message`](-message/index.md)`<`[`M`](-android-message/index.md#M)`, `[`B`](-android-message/index.md#B)`>, B : `[`Builder`](-message/-builder/index.md)`<`[`M`](-android-message/index.md#M)`, `[`B`](-android-message/index.md#B)`>> : `[`Message`](-message/index.md)`<`[`M`](-android-message/index.md#M)`, `[`B`](-android-message/index.md#B)`>`<br>An Android-specific [Message](-message/index.md) which adds support for [Parcelable](#). |
| [AnyMessage](-any-message/index.md) | `class AnyMessage : `[`Message`](-message/index.md)`<`[`AnyMessage`](-any-message/index.md)`, `[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`>`<br>TODO(oldergod): documentation TODO(oldergod): JSON |
| [EnumAdapter](-enum-adapter/index.md)<br>(JVM, js, native) | `abstract expect class EnumAdapter<E : `[`WireEnum`](-wire-enum/index.md)`> : `[`ProtoAdapter`](-proto-adapter/index.md)`<`[`E`](-enum-adapter/index.md#E)`>`<br>An abstract [ProtoAdapter](-proto-adapter/index.md) that converts values of an enum to and from integers. |
| [FieldEncoding](-field-encoding/index.md) | `enum class FieldEncoding` |
| [Message](-message/index.md)<br>(JVM, js, native) | `abstract expect class Message<M : `[`Message`](-message/index.md)`<`[`M`](-message/index.md#M)`, `[`B`](-message/index.md#B)`>, B : `[`Builder`](-message/-builder/index.md)`<`[`M`](-message/index.md#M)`, `[`B`](-message/index.md#B)`>>`<br>A protocol buffer message. |
| [MessageSink](-message-sink/index.md)<br>(JVM, js, native) | `expect interface MessageSink<in T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>`<br>A writable stream of messages. |
| [MessageSource](-message-source/index.md)<br>(JVM, js, native) | `expect interface MessageSource<out T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>`<br>A readable stream of messages. |
| [ProtoAdapter](-proto-adapter/index.md)<br>(JVM, js, native) | `abstract expect class ProtoAdapter<E>` |
| [ProtoReader](-proto-reader/index.md) | `class ProtoReader`<br>Reads and decodes protocol message fields. |
| [ProtoWriter](-proto-writer/index.md) | `class ProtoWriter`<br>Utilities for encoding and writing protocol message fields. |
| [Service](-service.md) | `interface Service` |
| [WireEnum](-wire-enum/index.md) | `interface WireEnum`<br>Interface for generated [Enum](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html) values to help serialization and deserialization. |

### Annotations

| Name | Summary |
|---|---|
| [WireField](-wire-field/index.md) | `annotation class WireField`<br>Annotates generated [Message](-message/index.md) fields with metadata for serialization and deserialization. |
| [WireRpc](-wire-rpc/index.md) | `annotation class WireRpc`<br>For gRPC actions the path is formatted as `/<service name>/<method name>`. The path of the proto service below is `/squareup.helloworld.Greeter/SayHello`. |

### Functions

| Name | Summary |
|---|---|
| [get](get.md)<br>(JVM) | `fun <T> get(value: `[`T`](get.md#T)`?, defaultValue: `[`T`](get.md#T)`): `[`T`](get.md#T)<br>Returns `value` if it is not null; `defaultValue` otherwise. This is used to conveniently return a default value when a value is null. For example, |
