[wire-schema](../../index.md) / [com.squareup.wire.schema](../index.md) / [Options](./index.md)

# Options

`class Options`

A set of options declared on a message declaration, field declaration, enum declaration, enum
constant declaration, service declaration, RPC method declaration, or proto file declaration.
Options values may be arbitrary protocol buffer messages, but must be valid protocol buffer
messages.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `Options(optionType: `[`ProtoType`](../-proto-type/index.md)`, optionElements: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`OptionElement`](../../com.squareup.wire.schema.internal.parser/-option-element/index.md)`>)`<br>A set of options declared on a message declaration, field declaration, enum declaration, enum constant declaration, service declaration, RPC method declaration, or proto file declaration. Options values may be arbitrary protocol buffer messages, but must be valid protocol buffer messages. |

### Properties

| Name | Summary |
|---|---|
| [elements](elements.md) | `val elements: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`OptionElement`](../../com.squareup.wire.schema.internal.parser/-option-element/index.md)`>` |
| [map](map.md) | `val map: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<`[`ProtoMember`](../-proto-member/index.md)`, `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?>` |

### Functions

| Name | Summary |
|---|---|
| [assignsMember](assigns-member.md) | `fun assignsMember(protoMember: `[`ProtoMember`](../-proto-member/index.md)`?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if these options assigns a value to [protoMember](assigns-member.md#com.squareup.wire.schema.Options$assignsMember(com.squareup.wire.schema.ProtoMember)/protoMember). |
| [fields](fields.md) | `fun fields(): `[`Multimap`](../-multimap/index.md)`<`[`ProtoType`](../-proto-type/index.md)`, `[`ProtoMember`](../-proto-member/index.md)`>`<br>`fun fields(pruningRules: `[`PruningRules`](../-pruning-rules/index.md)`): `[`Multimap`](../-multimap/index.md)`<`[`ProtoType`](../-proto-type/index.md)`, `[`ProtoMember`](../-proto-member/index.md)`>` |
| [get](get.md) | `fun get(protoMember: `[`ProtoMember`](../-proto-member/index.md)`): `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?` |
| [link](link.md) | `fun link(linker: `[`Linker`](../-linker/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [optionMatches](option-matches.md) | `fun optionMatches(namePattern: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, valuePattern: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if any of the options in [entries](#) matches both of the regular expressions provided: its name matches the option's name and its value matches the option's value. |
| [retainAll](retain-all.md) | `fun retainAll(schema: `[`Schema`](../-schema/index.md)`, markSet: `[`MarkSet`](../-mark-set/index.md)`): `[`Options`](./index.md) |
| [retainLinked](retain-linked.md) | `fun retainLinked(): `[`Options`](./index.md) |

### Companion Object Properties

| Name | Summary |
|---|---|
| [ENUM_OPTIONS](-e-n-u-m_-o-p-t-i-o-n-s.md) | `val ENUM_OPTIONS: `[`ProtoType`](../-proto-type/index.md) |
| [ENUM_VALUE_OPTIONS](-e-n-u-m_-v-a-l-u-e_-o-p-t-i-o-n-s.md) | `val ENUM_VALUE_OPTIONS: `[`ProtoType`](../-proto-type/index.md) |
| [FIELD_OPTIONS](-f-i-e-l-d_-o-p-t-i-o-n-s.md) | `val FIELD_OPTIONS: `[`ProtoType`](../-proto-type/index.md) |
| [FILE_OPTIONS](-f-i-l-e_-o-p-t-i-o-n-s.md) | `val FILE_OPTIONS: `[`ProtoType`](../-proto-type/index.md) |
| [GOOGLE_PROTOBUF_OPTION_TYPES](-g-o-o-g-l-e_-p-r-o-t-o-b-u-f_-o-p-t-i-o-n_-t-y-p-e-s.md) | `val GOOGLE_PROTOBUF_OPTION_TYPES: `[`Array`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-array/index.html)`<`[`ProtoType`](../-proto-type/index.md)`>` |
| [MESSAGE_OPTIONS](-m-e-s-s-a-g-e_-o-p-t-i-o-n-s.md) | `val MESSAGE_OPTIONS: `[`ProtoType`](../-proto-type/index.md) |
| [METHOD_OPTIONS](-m-e-t-h-o-d_-o-p-t-i-o-n-s.md) | `val METHOD_OPTIONS: `[`ProtoType`](../-proto-type/index.md) |
| [SERVICE_OPTIONS](-s-e-r-v-i-c-e_-o-p-t-i-o-n-s.md) | `val SERVICE_OPTIONS: `[`ProtoType`](../-proto-type/index.md) |

### Companion Object Functions

| Name | Summary |
|---|---|
| [resolveFieldPath](resolve-field-path.md) | `fun resolveFieldPath(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, fullyQualifiedNames: `[`Set`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?>): `[`Array`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-array/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`>?`<br>Given a path like `a.b.c.d` and a set of paths like `{a.b.c, a.f.g, h.j}`, this returns the original path split on dots such that the first element is in the set. For the above example it would return the array `[a.b.c, d]`. |
