[wire-schema](../../index.md) / [com.squareup.wire.schema](../index.md) / [ProtoMember](./index.md)

# ProtoMember

`class ProtoMember`

Identifies a field, enum or RPC on a declaring type. Members are encoded as strings containing a
type name, a hash, and a member name, like `squareup.dinosaurs.Dinosaur#length_meters`.

A member's name is typically a simple name like "length_meters" or "packed". If the member
field is an extension to its type, that name is prefixed with its enclosing package. This yields
a member name with two packages, like `google.protobuf.FieldOptions#squareup.units.unit`.

### Properties

| Name | Summary |
|---|---|
| [member](member.md) | `val member: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [type](type.md) | `val type: `[`ProtoType`](../-proto-type/index.md) |

### Functions

| Name | Summary |
|---|---|
| [equals](equals.md) | `fun equals(other: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [hashCode](hash-code.md) | `fun hashCode(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [toString](to-string.md) | `fun toString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

### Companion Object Functions

| Name | Summary |
|---|---|
| [get](get.md) | `fun get(typeAndMember: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`ProtoMember`](./index.md)<br>`fun get(type: `[`ProtoType`](../-proto-type/index.md)`, member: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`ProtoMember`](./index.md)<br>`fun get(type: `[`ProtoType`](../-proto-type/index.md)`, field: `[`Field`](../-field/index.md)`): `[`ProtoMember`](./index.md) |
