[wire-schema](../../index.md) / [com.squareup.wire.schema](../index.md) / [Linker](./index.md)

# Linker

`class Linker`

Links local field types and option types to the corresponding declarations.

### Functions

| Name | Summary |
|---|---|
| [addError](add-error.md) | `fun addError(message: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [addType](add-type.md) | `fun addType(protoType: `[`ProtoType`](../-proto-type/index.md)`, type: `[`Type`](../-type/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Adds [type](add-type.md#com.squareup.wire.schema.Linker$addType(com.squareup.wire.schema.ProtoType, com.squareup.wire.schema.Type)/type). |
| [dereference](dereference.md) | `fun dereference(self: `[`Field`](../-field/index.md)`, field: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Field`](../-field/index.md)`?`<br>Returns the field named [field](dereference.md#com.squareup.wire.schema.Linker$dereference(com.squareup.wire.schema.Field, kotlin.String)/field) on the message type of [self](dereference.md#com.squareup.wire.schema.Linker$dereference(com.squareup.wire.schema.Field, kotlin.String)/self). |
| [get](get.md) | `fun get(protoType: `[`ProtoType`](../-proto-type/index.md)`): `[`Type`](../-type/index.md)`?`<br>Returns the type or null if it doesn't exist. |
| [getForOptions](get-for-options.md) | `fun getForOptions(protoType: `[`ProtoType`](../-proto-type/index.md)`): `[`Type`](../-type/index.md)`?`<br>Returns the type or null if it doesn't exist. Before this returns it ensures members are linked so that options may dereference them. |
| [link](link.md) | `fun link(sourceProtoFiles: `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<`[`ProtoFile`](../-proto-file/index.md)`>): `[`Schema`](../-schema/index.md)<br>Link all features of all files in [sourceProtoFiles](link.md#com.squareup.wire.schema.Linker$link(kotlin.collections.Iterable((com.squareup.wire.schema.ProtoFile)))/sourceProtoFiles) to create a schema. This will also partially link any imported files necessary. |
| [packageName](package-name.md) | `fun packageName(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?`<br>Returns the current package name from the context stack. |
| [resolve](resolve.md) | `fun <T> resolve(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, map: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`T`](resolve.md#T)`>): `[`T`](resolve.md#T)`?` |
| [resolveMessageType](resolve-message-type.md) | `fun resolveMessageType(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`ProtoType`](../-proto-type/index.md)<br>Returns the type name for the relative or fully-qualified name [name](resolve-message-type.md#com.squareup.wire.schema.Linker$resolveMessageType(kotlin.String)/name). |
| [resolveType](resolve-type.md) | `fun resolveType(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`ProtoType`](../-proto-type/index.md)<br>Returns the type name for the scalar, relative or fully-qualified name [name](resolve-type.md#com.squareup.wire.schema.Linker$resolveType(kotlin.String)/name). |
| [validateEnumConstantNameUniqueness](validate-enum-constant-name-uniqueness.md) | `fun validateEnumConstantNameUniqueness(nestedTypes: `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<`[`Type`](../-type/index.md)`>): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [validateFields](validate-fields.md) | `fun validateFields(fields: `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<`[`Field`](../-field/index.md)`>, reserveds: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`Reserved`](../-reserved/index.md)`>, syntaxRules: `[`SyntaxRules`](../-syntax-rules/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Validate that the tags of [fields](validate-fields.md#com.squareup.wire.schema.Linker$validateFields(kotlin.collections.Iterable((com.squareup.wire.schema.Field)), kotlin.collections.List((com.squareup.wire.schema.Reserved)), com.squareup.wire.schema.SyntaxRules)/fields) are unique and in range. |
| [validateImport](validate-import.md) | `fun validateImport(location: `[`Location`](../-location/index.md)`, type: `[`ProtoType`](../-proto-type/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [withContext](with-context.md) | `fun withContext(context: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`): `[`Linker`](./index.md)<br>Returns a new linker that uses [context](with-context.md#com.squareup.wire.schema.Linker$withContext(kotlin.Any)/context) to resolve type names and report errors. |
