[wire-schema](../index.md) / [com.squareup.wire.schema](./index.md)

## Package com.squareup.wire.schema

### Types

| Name | Summary |
|---|---|
| [ClaimedDefinitions](-claimed-definitions/index.md)<br>(JVM) | `class ClaimedDefinitions` |
| [CoreLoader](-core-loader/index.md)<br>(JVM, js) | `expect object CoreLoader : `[`Loader`](-loader/index.md) |
| [EmittingRules](-emitting-rules/index.md)<br>(JVM) | `class EmittingRules`<br>A set of rules that describes which types to generate. |
| [EnclosingType](-enclosing-type/index.md) | `class EnclosingType : `[`Type`](-type/index.md)<br>An empty type which only holds nested types. |
| [EnumConstant](-enum-constant/index.md) | `class EnumConstant` |
| [EnumType](-enum-type/index.md) | `class EnumType : `[`Type`](-type/index.md) |
| [Extend](-extend/index.md) | `class Extend` |
| [Extensions](-extensions/index.md) | `class Extensions` |
| [Field](-field/index.md) | `class Field` |
| [LinkedOptionEntry](-linked-option-entry/index.md) | `data class LinkedOptionEntry` |
| [Linker](-linker/index.md) | `class Linker`<br>Links local field types and option types to the corresponding declarations. |
| [Loader](-loader/index.md) | `interface Loader`<br>Loads other files as needed by their import path. |
| [Location](-location/index.md) | `data class Location`<br>Locates a .proto file, or a position within a .proto file, on the file system. This includes a base directory or a .jar file, and a path relative to that base. |
| [MarkSet](-mark-set/index.md) | `class MarkSet`<br>A mark set is used in three phases: |
| [MessageType](-message-type/index.md) | `class MessageType : `[`Type`](-type/index.md) |
| [Multimap](-multimap/index.md)<br>(JVM, js) | `expect interface Multimap<K, V>` |
| [OneOf](-one-of/index.md) | `class OneOf` |
| [Options](-options/index.md) | `class Options`<br>A set of options declared on a message declaration, field declaration, enum declaration, enum constant declaration, service declaration, RPC method declaration, or proto file declaration. Options values may be arbitrary protocol buffer messages, but must be valid protocol buffer messages. |
| [ProtoFile](-proto-file/index.md) | `class ProtoFile` |
| [ProtoMember](-proto-member/index.md) | `class ProtoMember`<br>Identifies a field, enum or RPC on a declaring type. Members are encoded as strings containing a type name, a hash, and a member name, like `squareup.dinosaurs.Dinosaur#length_meters`. |
| [ProtoType](-proto-type/index.md) | `class ProtoType`<br>Names a protocol buffer message, enumerated type, service, map, or a scalar. This class models a fully-qualified name using the protocol buffer package. |
| [PruningRules](-pruning-rules/index.md) | `class PruningRules`<br>A set of rules that describes which types and members to retain and which to remove. |
| [Reserved](-reserved/index.md) | `class Reserved` |
| [Rpc](-rpc/index.md) | `class Rpc` |
| [Schema](-schema/index.md) | `class Schema`<br>A collection of .proto files that describe a set of messages. A schema is *linked*: each field's type name is resolved to the corresponding type definition. |
| [SchemaLoader](-schema-loader/index.md)<br>(JVM) | `class SchemaLoader`<br>Load proto files and their transitive dependencies, parse them, and link them together. |
| [Service](-service/index.md) | `class Service` |
| [SyntaxRules](-syntax-rules/index.md) | `interface SyntaxRules`<br>A set of rules which defines schema requirements for a specific [Syntax](-proto-file/-syntax/index.md). |
| [Type](-type/index.md) | `abstract class Type` |

### Exceptions

| Name | Summary |
|---|---|
| [SchemaException](-schema-exception/index.md) | `class SchemaException : `[`RuntimeException`](http://docs.oracle.com/javase/8/docs/api/java/lang/RuntimeException.html) |
