[wire-grpc-client](../index.md) / [com.squareup.wire](index.md) / [GrpcCall](./-grpc-call.md)

# GrpcCall

`fun <S : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, R : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> GrpcCall(function: (`[`S`](-grpc-call.md#S)`) -> `[`R`](-grpc-call.md#R)`): <ERROR CLASS><`[`S`](-grpc-call.md#S)`, `[`R`](-grpc-call.md#R)`>`

**Platform and version requirements:** JVM

Returns a new instance of [GrpcCall](./-grpc-call.md) that can be used for a single call to
[execute](#), [executeBlocking](#), or
[enqueue](#).

The returned instance executes [function](-grpc-call.md#com.squareup.wire$GrpcCall(kotlin.Function1((com.squareup.wire.GrpcCall.S, com.squareup.wire.GrpcCall.R)))/function) synchronously on the calling thread, regardless of
which function is called. If [function](-grpc-call.md#com.squareup.wire$GrpcCall(kotlin.Function1((com.squareup.wire.GrpcCall.S, com.squareup.wire.GrpcCall.R)))/function) throws, the thrown exception will be wrapped in an
[IOException](#).

This method is useful when implementing the interfaces that are generated by Wire:

```
override fun GetFeature(): GrpcCall<Point, Feature> {
  return GrpcCall<Point, Feature> { request ->
    return@GrpcCall lookupNearestFeature(request.latitude, request.longitude)
  }
}
```

It is succinct when used in an expression function:

```
override fun GetFeature() = GrpcCall<Point, Feature> { request ->
  return@GrpcCall lookupNearestFeature(request.latitude, request.longitude)
}
```

