//[wire-compiler](../../../index.md)/[com.squareup.wire.schema](../index.md)/[SchemaLoader](index.md)

# SchemaLoader

[jvm]\
class [SchemaLoader](index.md) : [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html), Loader, [ProfileLoader](../-profile-loader/index.md)

Load proto files and their transitive dependencies and parse them. Keep track of which files were loaded from where so that we can use that information later when deciding what to generate.

## Constructors

| | |
|---|---|
| [SchemaLoader](-schema-loader.md) | [jvm]<br>fun [SchemaLoader](-schema-loader.md)(fileSystem: [FileSystem](https://docs.oracle.com/javase/8/docs/api/java/nio/file/FileSystem.html)) |
| [SchemaLoader](-schema-loader.md) | [jvm]<br>fun [SchemaLoader](-schema-loader.md)(fileSystem: FileSystem) |

## Functions

| Name | Summary |
|---|---|
| [close](close.md) | [jvm]<br>open override fun [close](close.md)() |
| [initRoots](init-roots.md) | [jvm]<br>fun [initRoots](init-roots.md)(sourcePath: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;Location&gt;, protoPath: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;Location&gt; = listOf())<br>Initialize the [WireRun.sourcePath](../-wire-run/source-path.md) and [WireRun.protoPath](../-wire-run/proto-path.md) from which files are loaded. |
| [load](load.md) | [jvm]<br>open override fun [load](load.md)(path: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): ProtoFile |
| [loadProfile](load-profile.md) | [jvm]<br>open override fun [loadProfile](load-profile.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), schema: Schema): Profile |
| [loadSchema](load-schema.md) | [jvm]<br>fun [loadSchema](load-schema.md)(): Schema |
| [withErrors](with-errors.md) | [jvm]<br>open override fun [withErrors](with-errors.md)(errors: ErrorCollector): [SchemaLoader](index.md) |

## Properties

| Name | Summary |
|---|---|
| [loadExhaustively](load-exhaustively.md) | [jvm]<br>var [loadExhaustively](load-exhaustively.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false<br>If true, the schema loader will load the whole graph, including files and types not used by anything in the source path. |
| [permitPackageCycles](permit-package-cycles.md) | [jvm]<br>var [permitPackageCycles](permit-package-cycles.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false<br>Strict by default. Note that golang cannot build protos with package cycles. |
| [sourcePathFiles](source-path-files.md) | [jvm]<br>var [sourcePathFiles](source-path-files.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;ProtoFile&gt;<br>Subset of the schema that was loaded from the source path. |
