[wire-schema](../../index.md) / [com.squareup.wire.schema.internal](../index.md) / [SchemaEncoder](index.md) / [&lt;init&gt;](./-init-.md)

# &lt;init&gt;

`SchemaEncoder(schema: `[`Schema`](../../com.squareup.wire.schema/-schema/index.md)`)`

This class encodes files from a Wire schema using the types in protobuf's `descriptor.proto`.
Unfortunately, the two models don't line up directly:

* Wire keeps a heterogeneous list of messages and enums; `descriptor.proto` keeps each in its
    own list.

* Descriptors don't have first class support for [Field.EncodeMode.OMIT_IDENTITY](../../com.squareup.wire.schema/-field/-encode-mode/-o-m-i-t_-i-d-e-n-t-i-t-y.md), which is the
    default in proto3. Instead these are synthesized with oneofs.

* Descriptors don't support maps. Instead these are synthesized with entry classes.

This file requires we manually keep tags and types in sync with `descriptor.proto`.

TODO(jwilson): this class doesn't yet extension ranges and several other fields that are
    commented out below.

