//[wire-grpc-client](../../index.md)/[com.squareup.wire](index.md)/[GrpcCall](-grpc-call.md)

# GrpcCall

[jvm]\

@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "grpcCall")

fun &lt;[S](-grpc-call.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), [R](-grpc-call.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [GrpcCall](-grpc-call.md)(function: ([S](-grpc-call.md)) -&gt; [R](-grpc-call.md)): GrpcCall&lt;[S](-grpc-call.md), [R](-grpc-call.md)&gt;

Returns a new instance of GrpcCall that can be used for a single call to execute, executeBlocking, or enqueue.

The returned instance executes [function](-grpc-call.md) synchronously on the calling thread, regardless of which blocking mode is used. If [function](-grpc-call.md) throws, the thrown exception will be wrapped in an IOException.

This method is useful when implementing the interfaces that are generated by Wire:

override fun GetFeature(): GrpcCall&lt;Point, Feature&gt; {\
  return GrpcCall&lt;Point, Feature&gt; { request -&gt;\
    return@GrpcCall lookupNearestFeature(request.latitude, request.longitude)\
  }\
}

It is succinct when used in an expression function:

override fun GetFeature() = GrpcCall&lt;Point, Feature&gt; { request -&gt;\
  return@GrpcCall lookupNearestFeature(request.latitude, request.longitude)\
}
