//[wire-runtime](../../../index.md)/[com.squareup.wire](../index.md)/[ProtoAdapter](index.md)

# ProtoAdapter

[common]\
abstract class [ProtoAdapter](index.md)&lt;[E](index.md)&gt;(fieldEncoding: [FieldEncoding](../-field-encoding/index.md), type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;?, typeUrl: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, syntax: [Syntax](../-syntax/index.md), identity: [E](index.md)?, sourceFile: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?)

[js, jvm, native]\
abstract class [ProtoAdapter](index.md)&lt;[E](index.md)&gt;(fieldEncoding: FieldEncoding, type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;?, typeUrl: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, syntax: Syntax, identity: [E](index.md)?, sourceFile: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?)

## Constructors

| | |
|---|---|
| [ProtoAdapter](-proto-adapter.md) | [jvm]<br>fun [ProtoAdapter](-proto-adapter.md)(fieldEncoding: FieldEncoding, type: [Class](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)&lt;*&gt;) |
| [ProtoAdapter](-proto-adapter.md) | [jvm]<br>fun [ProtoAdapter](-proto-adapter.md)(fieldEncoding: FieldEncoding, type: [Class](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)&lt;*&gt;, typeUrl: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?) |
| [ProtoAdapter](-proto-adapter.md) | [jvm]<br>fun [ProtoAdapter](-proto-adapter.md)(fieldEncoding: FieldEncoding, type: [Class](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)&lt;*&gt;, typeUrl: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, syntax: Syntax) |
| [ProtoAdapter](-proto-adapter.md) | [jvm]<br>fun &lt;[E](index.md)&gt; [ProtoAdapter](-proto-adapter.md)(fieldEncoding: FieldEncoding, type: [Class](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)&lt;*&gt;, typeUrl: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, syntax: Syntax, identity: [E](index.md)?) |
| [ProtoAdapter](-proto-adapter.md) | [jvm]<br>fun [ProtoAdapter](-proto-adapter.md)(fieldEncoding: FieldEncoding, type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;?) |
| [ProtoAdapter](-proto-adapter.md) | [jvm]<br>fun [ProtoAdapter](-proto-adapter.md)(fieldEncoding: FieldEncoding, type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;?, typeUrl: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?) |
| [ProtoAdapter](-proto-adapter.md) | [jvm]<br>fun [ProtoAdapter](-proto-adapter.md)(fieldEncoding: FieldEncoding, type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;?, typeUrl: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, syntax: Syntax) |
| [ProtoAdapter](-proto-adapter.md) | [jvm]<br>fun &lt;[E](index.md)&gt; [ProtoAdapter](-proto-adapter.md)(fieldEncoding: FieldEncoding, type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;?, typeUrl: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, syntax: Syntax, identity: [E](index.md)?) |
| [ProtoAdapter](-proto-adapter.md) | [jvm]<br>fun &lt;[E](index.md)&gt; [ProtoAdapter](-proto-adapter.md)(fieldEncoding: FieldEncoding, type: [Class](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)&lt;*&gt;, typeUrl: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, syntax: Syntax, identity: [E](index.md)?, sourceFile: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?) |

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [common, js, jvm, native]<br>[common, js, jvm, native]<br>object [Companion](-companion/index.md) |
| [EnumConstantNotFoundException](-enum-constant-not-found-exception/index.md) | [common, js, jvm, native]<br>[common, js, native]<br>class [EnumConstantNotFoundException](-enum-constant-not-found-exception/index.md)(value: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;?) : [IllegalArgumentException](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-illegal-argument-exception/index.html)<br>[jvm]<br>class [EnumConstantNotFoundException](-enum-constant-not-found-exception/index.md)(value: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;?) : [IllegalArgumentException](https://docs.oracle.com/javase/8/docs/api/java/lang/IllegalArgumentException.html) |

## Functions

| Name | Summary |
|---|---|
| [asPacked](as-packed.md) | [common, js, native]<br>[common, js, native]<br>fun [asPacked](as-packed.md)(): [ProtoAdapter](index.md)&lt;[List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[E](index.md)&gt;&gt;<br>Returns an adapter for E but as a packed, repeated value.<br>[jvm]<br>fun [asPacked](as-packed.md)(): [ProtoAdapter](index.md)&lt;[List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[E](index.md)&gt;&gt; |
| [asRepeated](as-repeated.md) | [common, js, native]<br>[common, js, native]<br>fun [asRepeated](as-repeated.md)(): [ProtoAdapter](index.md)&lt;[List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[E](index.md)&gt;&gt;<br>Returns an adapter for E but as a repeated value.<br>[jvm]<br>fun [asRepeated](as-repeated.md)(): [ProtoAdapter](index.md)&lt;[List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[E](index.md)&gt;&gt; |
| [decode](decode.md) | [common, js, native]<br>[common, js, native]<br>fun [decode](decode.md)(source: &lt;ERROR CLASS&gt;): [E](index.md)<br>Read an encoded message from source.<br>[common, js, native]<br>[common, js, native]<br>fun [decode](decode.md)(bytes: &lt;ERROR CLASS&gt;): [E](index.md)<br>[common, js, native]<br>fun [decode](decode.md)(bytes: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [E](index.md)<br>Read an encoded message from bytes.<br>[common, js, native]<br>[common]<br>abstract fun [decode](decode.md)(reader: [ProtoReader](../-proto-reader/index.md)): [E](index.md)<br>[js, native]<br>abstract fun [decode](decode.md)(reader: ProtoReader): [E](index.md)<br>Read a non-null value from reader.<br>[jvm]<br>abstract fun [decode](decode.md)(reader: ProtoReader): [E](index.md)<br>fun [decode](decode.md)(stream: [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html)): [E](index.md)<br>fun [decode](decode.md)(bytes: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [E](index.md) |
| [encode](encode.md) | [common, js, native]<br>[common, js, native]<br>fun [encode](encode.md)(value: [E](index.md)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>Encode value as a byte[].<br>[jvm]<br>fun [encode](encode.md)(value: [E](index.md)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>abstract fun [encode](encode.md)(writer: ProtoWriter, value: [E](index.md))<br>open fun [encode](encode.md)(writer: ReverseProtoWriter, value: [E](index.md))<br>fun [encode](encode.md)(stream: [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html), value: [E](index.md))<br>[common, js, native]<br>[common, js, native]<br>fun [encode](encode.md)(sink: &lt;ERROR CLASS&gt;, value: [E](index.md))<br>Encode value and write it to stream.<br>[common, js, native]<br>[common]<br>abstract fun [encode](encode.md)(writer: [ProtoWriter](../-proto-writer/index.md), value: [E](index.md))<br>[js, native]<br>abstract fun [encode](encode.md)(writer: ProtoWriter, value: [E](index.md))<br>[common]<br>open fun [encode](encode.md)(writer: [ReverseProtoWriter](../-reverse-proto-writer/index.md), value: [E](index.md))<br>[js, native]<br>open fun [encode](encode.md)(writer: ReverseProtoWriter, value: [E](index.md))<br>Write non-null value to writer. |
| [encodeByteString](encode-byte-string.md) | [common, js, native]<br>[common, js, native]<br>fun [encodeByteString](encode-byte-string.md)(value: [E](index.md)): &lt;ERROR CLASS&gt;<br>Encode value as a ByteString.<br>[jvm]<br>fun [encodeByteString](encode-byte-string.md)(value: [E](index.md)): &lt;ERROR CLASS&gt; |
| [encodedSize](encoded-size.md) | [common, js, native]<br>[common, js, native]<br>abstract fun [encodedSize](encoded-size.md)(value: [E](index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>The size of the non-null data value. This does not include the size required for a length-delimited prefix (should the type require one).<br>[jvm]<br>abstract fun [encodedSize](encoded-size.md)(value: [E](index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [encodedSizeWithTag](encoded-size-with-tag.md) | [common, js, native]<br>[common, js, native]<br>open fun [encodedSizeWithTag](encoded-size-with-tag.md)(tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>The size of tag and value in the wire format. This size includes the tag, type, length-delimited prefix (should the type require one), and value. Returns 0 if value is null.<br>[jvm]<br>open fun [encodedSizeWithTag](encoded-size-with-tag.md)(tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [encodeWithTag](encode-with-tag.md) | [common, js, native]<br>[common]<br>open fun [encodeWithTag](encode-with-tag.md)(writer: [ProtoWriter](../-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?)<br>[js, native]<br>open fun [encodeWithTag](encode-with-tag.md)(writer: ProtoWriter, tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?)<br>[common]<br>open fun [encodeWithTag](encode-with-tag.md)(writer: [ReverseProtoWriter](../-reverse-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?)<br>[js, native]<br>open fun [encodeWithTag](encode-with-tag.md)(writer: ReverseProtoWriter, tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?)<br>Write tag and value to writer. If value is null this does nothing.<br>[jvm]<br>open fun [encodeWithTag](encode-with-tag.md)(writer: ProtoWriter, tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?)<br>open fun [encodeWithTag](encode-with-tag.md)(writer: ReverseProtoWriter, tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?) |
| [redact](redact.md) | [common, js, native]<br>[common, js, native]<br>abstract fun [redact](redact.md)(value: [E](index.md)): [E](index.md)<br>Returns the redacted form of value.<br>[jvm]<br>abstract fun [redact](redact.md)(value: [E](index.md)): [E](index.md) |
| [toString](to-string.md) | [common, js, native]<br>[common, js, native]<br>open fun [toString](to-string.md)(value: [E](index.md)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns a human-readable version of the given value.<br>[jvm]<br>open fun [toString](to-string.md)(value: [E](index.md)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

## Properties

| Name | Summary |
|---|---|
| [identity](identity.md) | [common]<br>val [identity](identity.md): [E](index.md)?<br>A special value that is used when a field is absent from an encoded proto3 message. When encoding a proto3 message, fields that hold this value will be omitted.<br>[js, jvm, native]<br>val [identity](identity.md): [E](index.md)? |
| [sourceFile](source-file.md) | [common]<br>val [sourceFile](source-file.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?<br>Path to the file containing the protobuf definition of this type.<br>[js, jvm, native]<br>val [sourceFile](source-file.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |
| [syntax](syntax.md) | [common]<br>val [syntax](syntax.md): [Syntax](../-syntax/index.md)<br>Identifies the syntax in which [type](type.md) is defined in the proto schema. This string contains either "proto2" or "proto3".<br>[js, jvm, native]<br>val [syntax](syntax.md): Syntax |
| [type](type.md) | [common, js, jvm, native]<br>val [type](type.md): [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;? |
| [typeUrl](type-url.md) | [common]<br>val [typeUrl](type-url.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?<br>Identifies this type for inclusion in a google.protobuf.Any. This is a string like "type.googleapis.com/packagename.messagename" or null if this type is either not a message (such as scalars and enums), or was code-generated before Wire 3.2 which introduced support for type URLS.<br>[js, jvm, native]<br>val [typeUrl](type-url.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |

## Inheritors

| Name |
|---|
| [IntProtoAdapter](../-int-proto-adapter/index.md) |
| [LongProtoAdapter](../-long-proto-adapter/index.md) |
| [FloatProtoAdapter](../-float-proto-adapter/index.md) |
| [DoubleProtoAdapter](../-double-proto-adapter/index.md) |
| [EnumAdapter](../-enum-adapter/index.md) |
| [ProtoAdapter.Companion](-companion/-unsupported-type-proto-adapter/index.md) |

## Extensions

| Name | Summary |
|---|---|
| [decode](../decode.md) | [darwin]<br>@[ExperimentalUnsignedTypes](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-experimental-unsigned-types/index.html)<br>fun &lt;[E](../decode.md)&gt; [ProtoAdapter](index.md#-1395866391%2FExtensions%2F1267709915)&lt;[E](../decode.md)&gt;.[decode](../decode.md)(data: &lt;ERROR CLASS&gt;): [E](../decode.md)<br>Read an encoded message from data. |
