//[wire-runtime](../../../index.md)/[com.squareup.wire](../index.md)/[EnumAdapter](index.md)

# EnumAdapter

[common]\
abstract class [EnumAdapter](index.md)&lt;[E](index.md) : [WireEnum](../-wire-enum/index.md)&gt; : [ProtoAdapter](../-proto-adapter/index.md)&lt;[E](index.md)&gt; 

An abstract [ProtoAdapter](../-proto-adapter/index.md) that converts values of an enum to and from integers.

[js, jvm, native]\
abstract class [EnumAdapter](index.md)&lt;[E](index.md) : WireEnum&gt; : [ProtoAdapter](../-proto-adapter/index.md)&lt;[E](index.md)&gt; 

An abstract [ProtoAdapter](../-proto-adapter/index.md) that converts values of an enum to and from integers.

## Constructors

| | |
|---|---|
| [EnumAdapter](-enum-adapter.md) | [jvm]<br>fun &lt;[E](index.md) : WireEnum&gt; [EnumAdapter](-enum-adapter.md)(type: [Class](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)&lt;[E](index.md)&gt;, syntax: Syntax, identity: [E](index.md)?) |
| [EnumAdapter](-enum-adapter.md) | [jvm]<br>fun &lt;[E](index.md) : WireEnum&gt; [EnumAdapter](-enum-adapter.md)(type: [Class](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)&lt;[E](index.md)&gt;) |
| [EnumAdapter](-enum-adapter.md) | [jvm]<br>fun &lt;[E](index.md) : WireEnum&gt; [EnumAdapter](-enum-adapter.md)(type: [Class](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)&lt;[E](index.md)&gt;, syntax: Syntax) |
| [EnumAdapter](-enum-adapter.md) | [jvm]<br>fun &lt;[E](index.md) : WireEnum&gt; [EnumAdapter](-enum-adapter.md)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;[E](index.md)&gt;) |
| [EnumAdapter](-enum-adapter.md) | [jvm]<br>fun &lt;[E](index.md) : WireEnum&gt; [EnumAdapter](-enum-adapter.md)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;[E](index.md)&gt;, syntax: Syntax) |

## Functions

| Name | Summary |
|---|---|
| [asPacked](../-proto-adapter/as-packed.md) | [common, js, native]<br>[common, js, native]<br>fun [asPacked](../-proto-adapter/as-packed.md)(): [ProtoAdapter](../-proto-adapter/index.md)&lt;[List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[E](index.md)&gt;&gt;<br>Returns an adapter for E but as a packed, repeated value.<br>[jvm]<br>fun [asPacked](../-proto-adapter/as-packed.md)(): [ProtoAdapter](../-proto-adapter/index.md)&lt;[List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[E](index.md)&gt;&gt; |
| [asRepeated](../-proto-adapter/as-repeated.md) | [common, js, native]<br>[common, js, native]<br>fun [asRepeated](../-proto-adapter/as-repeated.md)(): [ProtoAdapter](../-proto-adapter/index.md)&lt;[List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[E](index.md)&gt;&gt;<br>Returns an adapter for E but as a repeated value.<br>[jvm]<br>fun [asRepeated](../-proto-adapter/as-repeated.md)(): [ProtoAdapter](../-proto-adapter/index.md)&lt;[List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[E](index.md)&gt;&gt; |
| [decode](decode.md) | [common, js, native]<br>[common]<br>open override fun [decode](decode.md)(reader: [ProtoReader](../-proto-reader/index.md)): [E](index.md)<br>[js, native]<br>open override fun [decode](decode.md)(reader: ProtoReader): [E](index.md)<br>Read a non-null value from reader.<br>[jvm]<br>open override fun [decode](decode.md)(reader: ProtoReader): [E](index.md)<br>fun [decode](../-proto-adapter/decode.md)(stream: [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html)): [E](index.md)<br>fun [decode](../-proto-adapter/decode.md)(bytes: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [E](index.md)<br>[common, js, native]<br>[common, js, native]<br>fun [decode](../-proto-adapter/decode.md)(bytes: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [E](index.md)<br>Read an encoded message from bytes. |
| encode | [common, js, native]<br>[common]<br>fun [encode](index.md#362516774%2FFunctions%2F-1082500773)(value: [E](index.md)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>[js]<br>fun [encode](index.md#362516774%2FFunctions%2F-1733684867)(value: [E](index.md)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>[native]<br>fun [encode](index.md#362516774%2FFunctions%2F467161563)(value: [E](index.md)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>Encode value as a byte[].<br>[jvm]<br>fun [encode](index.md#362516774%2FFunctions%2F1823866683)(value: [E](index.md)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>open override fun [encode](encode.md)(writer: ProtoWriter, value: [E](index.md))<br>open override fun [encode](encode.md)(writer: ReverseProtoWriter, value: [E](index.md))<br>fun [encode](index.md#1817321442%2FFunctions%2F1823866683)(stream: [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html), value: [E](index.md))<br>[common, js, native]<br>[common]<br>open override fun [encode](encode.md)(writer: [ProtoWriter](../-proto-writer/index.md), value: [E](index.md))<br>[js, native]<br>open override fun [encode](encode.md)(writer: ProtoWriter, value: [E](index.md))<br>[common]<br>open override fun [encode](encode.md)(writer: [ReverseProtoWriter](../-reverse-proto-writer/index.md), value: [E](index.md))<br>[js, native]<br>open override fun [encode](encode.md)(writer: ReverseProtoWriter, value: [E](index.md))<br>Write non-null value to writer. |
| encodeByteString | [common, js, native]<br>[common]<br>fun [encodeByteString](index.md#-320012307%2FFunctions%2F-1082500773)(value: [E](index.md)): &lt;ERROR CLASS&gt;<br>[js]<br>fun [encodeByteString](index.md#-320012307%2FFunctions%2F-1733684867)(value: [E](index.md)): &lt;ERROR CLASS&gt;<br>[native]<br>fun [encodeByteString](index.md#-320012307%2FFunctions%2F467161563)(value: [E](index.md)): &lt;ERROR CLASS&gt;<br>Encode value as a ByteString.<br>[jvm]<br>fun [encodeByteString](index.md#-320012307%2FFunctions%2F1823866683)(value: [E](index.md)): &lt;ERROR CLASS&gt; |
| [encodedSize](encoded-size.md) | [common, js, native]<br>[common, js, native]<br>open override fun [encodedSize](encoded-size.md)(value: [E](index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>The size of the non-null data value. This does not include the size required for a length-delimited prefix (should the type require one).<br>[jvm]<br>open override fun [encodedSize](encoded-size.md)(value: [E](index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| encodedSizeWithTag | [common, js, native]<br>[common]<br>open fun [encodedSizeWithTag](index.md#804415853%2FFunctions%2F-1082500773)(tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[js]<br>open fun [encodedSizeWithTag](index.md#804415853%2FFunctions%2F-1733684867)(tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[native]<br>open fun [encodedSizeWithTag](index.md#804415853%2FFunctions%2F467161563)(tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>The size of tag and value in the wire format. This size includes the tag, type, length-delimited prefix (should the type require one), and value. Returns 0 if value is null.<br>[jvm]<br>open fun [encodedSizeWithTag](index.md#804415853%2FFunctions%2F1823866683)(tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| encodeWithTag | [common, js, native]<br>[common]<br>open fun [encodeWithTag](index.md#-1882930246%2FFunctions%2F-1082500773)(writer: [ProtoWriter](../-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?)<br>[js]<br>open fun [encodeWithTag](index.md#-1882930246%2FFunctions%2F-1733684867)(writer: ProtoWriter, tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?)<br>[native]<br>open fun [encodeWithTag](index.md#-1882930246%2FFunctions%2F467161563)(writer: ProtoWriter, tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?)<br>[common]<br>open fun [encodeWithTag](index.md#1543761198%2FFunctions%2F-1082500773)(writer: [ReverseProtoWriter](../-reverse-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?)<br>[js]<br>open fun [encodeWithTag](index.md#1543761198%2FFunctions%2F-1733684867)(writer: ReverseProtoWriter, tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?)<br>[native]<br>open fun [encodeWithTag](index.md#1543761198%2FFunctions%2F467161563)(writer: ReverseProtoWriter, tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?)<br>Write tag and value to writer. If value is null this does nothing.<br>[jvm]<br>open fun [encodeWithTag](index.md#-1882930246%2FFunctions%2F1823866683)(writer: ProtoWriter, tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?)<br>open fun [encodeWithTag](index.md#1543761198%2FFunctions%2F1823866683)(writer: ReverseProtoWriter, tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?) |
| [redact](redact.md) | [common, js, native]<br>[common, js, native]<br>open override fun [redact](redact.md)(value: [E](index.md)): [E](index.md)<br>Returns the redacted form of value.<br>[jvm]<br>open override fun [redact](redact.md)(value: [E](index.md)): [E](index.md) |
| toString | [common, js, native]<br>[common]<br>open fun [toString](index.md#-2000452144%2FFunctions%2F-1082500773)(value: [E](index.md)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[js]<br>open fun [toString](index.md#-2000452144%2FFunctions%2F-1733684867)(value: [E](index.md)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[native]<br>open fun [toString](index.md#-2000452144%2FFunctions%2F467161563)(value: [E](index.md)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns a human-readable version of the given value.<br>[jvm]<br>open fun [toString](index.md#-2000452144%2FFunctions%2F1823866683)(value: [E](index.md)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| tryDecode | [common]<br>fun [tryDecode](index.md#-1386937699%2FFunctions%2F-1082500773)(reader: [ProtoReader](../-proto-reader/index.md), destination: [MutableList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)&lt;[E](index.md)&gt;)<br>Reads a value and appends it to [destination](index.md#-1386937699%2FFunctions%2F-1082500773) if this has data available. Otherwise, it will only clear the reader state.<br>[js, jvm, native]<br>[js]<br>fun [tryDecode](index.md#-1386937699%2FFunctions%2F-1733684867)(reader: ProtoReader, destination: [MutableList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)&lt;[E](index.md)&gt;)<br>[jvm]<br>fun [tryDecode](index.md#-1386937699%2FFunctions%2F1823866683)(reader: ProtoReader, destination: [MutableList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)&lt;[E](index.md)&gt;)<br>[native]<br>fun [tryDecode](index.md#-1386937699%2FFunctions%2F467161563)(reader: ProtoReader, destination: [MutableList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)&lt;[E](index.md)&gt;) |

## Properties

| Name | Summary |
|---|---|
| [identity](../-proto-adapter/identity.md) | [common]<br>val [identity](../-proto-adapter/identity.md): [E](index.md)?<br>A special value that is used when a field is absent from an encoded proto3 message. When encoding a proto3 message, fields that hold this value will be omitted.<br>[js, jvm, native]<br>val [identity](../-proto-adapter/identity.md): [E](index.md)? |
| [sourceFile](../-proto-adapter/source-file.md) | [common]<br>val [sourceFile](../-proto-adapter/source-file.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?<br>Path to the file containing the protobuf definition of this type.<br>[js, jvm, native]<br>val [sourceFile](../-proto-adapter/source-file.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |
| [syntax](../-proto-adapter/syntax.md) | [common]<br>val [syntax](../-proto-adapter/syntax.md): [Syntax](../-syntax/index.md)<br>Identifies the syntax in which [type](../-proto-adapter/type.md) is defined in the proto schema. This string contains either "proto2" or "proto3".<br>[js, jvm, native]<br>val [syntax](../-proto-adapter/syntax.md): Syntax |
| [type](../-proto-adapter/type.md) | [common, js, jvm, native]<br>val [type](../-proto-adapter/type.md): [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;? |
| [typeUrl](../-proto-adapter/type-url.md) | [common]<br>val [typeUrl](../-proto-adapter/type-url.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?<br>Identifies this type for inclusion in a google.protobuf.Any. This is a string like "type.googleapis.com/packagename.messagename" or null if this type is either not a message (such as scalars and enums), or was code-generated before Wire 3.2 which introduced support for type URLS.<br>[js, jvm, native]<br>val [typeUrl](../-proto-adapter/type-url.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |

## Inheritors

| Name |
|---|
| [RuntimeEnumAdapter](../-runtime-enum-adapter/index.md) |
