//[wire-runtime](../../../index.md)/[com.squareup.wire.internal](../index.md)/[FieldBinding](index.md)

# FieldBinding

[jvm]\
class [FieldBinding](index.md)&lt;[M](index.md) : [Message](../../com.squareup.wire/-message/index.md)&lt;[M](index.md), [B](index.md)&gt;, [B](index.md) : [Message.Builder](../../com.squareup.wire/-message/-builder/index.md)&lt;[M](index.md), [B](index.md)&gt;&gt; : [FieldOrOneOfBinding](../-field-or-one-of-binding/index.md)&lt;[M](index.md), [B](index.md)&gt; 

Read, write, and describe a tag within a message. This class knows how to assign fields to a builder object, and how to extract values from a message object.

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |

## Properties

| Name | Summary |
|---|---|
| [adapter](../-field-or-one-of-binding/adapter.md) | [jvm]<br>val [adapter](../-field-or-one-of-binding/adapter.md): [ProtoAdapter](../../com.squareup.wire/-proto-adapter/index.md)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; |
| [declaredName](declared-name.md) | [jvm]<br>open override val [declaredName](declared-name.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>The name of the field as declared in the `.proto` file. |
| [isMap](is-map.md) | [jvm]<br>open override val [isMap](is-map.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [isMessage](is-message.md) | [jvm]<br>open override val [isMessage](is-message.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [keyAdapter](key-adapter.md) | [jvm]<br>open override val [keyAdapter](key-adapter.md): [ProtoAdapter](../../com.squareup.wire/-proto-adapter/index.md)&lt;*&gt; |
| [label](label.md) | [jvm]<br>open override val [label](label.md): [WireField.Label](../../com.squareup.wire/-wire-field/-label/index.md) |
| [name](name.md) | [jvm]<br>open override val [name](name.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>The name of the field in generated code. If the declared name is a keyword like `fun`, this will be a transformed name like `fun_`. |
| [redacted](redacted.md) | [jvm]<br>open override val [redacted](redacted.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [singleAdapter](single-adapter.md) | [jvm]<br>open override val [singleAdapter](single-adapter.md): [ProtoAdapter](../../com.squareup.wire/-proto-adapter/index.md)&lt;*&gt; |
| [tag](tag.md) | [jvm]<br>open override val [tag](tag.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [wireFieldJsonName](wire-field-json-name.md) | [jvm]<br>open override val [wireFieldJsonName](wire-field-json-name.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>The JSON name as determined at code-generation name. This is usually camelCase even if the field is declared in snake_case. |
| [writeIdentityValues](write-identity-values.md) | [jvm]<br>open override val [writeIdentityValues](write-identity-values.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>If true, Wire will always write identity values. |

## Functions

| Name | Summary |
|---|---|
| [get](get.md) | [jvm]<br>open operator override fun [get](get.md)(message: [M](index.md)): [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)? |
| [getFromBuilder](get-from-builder.md) | [jvm]<br>open override fun [getFromBuilder](get-from-builder.md)(builder: [B](index.md)): [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)? |
| [omitFromJson](../-field-or-one-of-binding/omit-from-json.md) | [jvm]<br>fun [omitFromJson](../-field-or-one-of-binding/omit-from-json.md)(syntax: [Syntax](../../com.squareup.wire/-syntax/index.md), value: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [set](set.md) | [jvm]<br>open override fun [set](set.md)(builder: [B](index.md), value: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?)<br>Assign a single value for required/optional fields, or a list for repeated/packed fields. |
| [value](value.md) | [jvm]<br>open override fun [value](value.md)(builder: [B](index.md), value: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html))<br>Accept a single value, independent of whether this value is single or repeated. |
