//[wire-runtime](../../../index.md)/[com.squareup.wire.internal](../index.md)/[JsonIntegration](index.md)

# JsonIntegration

[jvm]\
abstract class [JsonIntegration](index.md)&lt;[F](index.md), [A](index.md)&gt;

Integrates a JSON library like Moshi or Gson into proto. This rigid interface attempts to make it easy all JSON libraries to encode and decode JSON in the exact same way.

## Constructors

| | |
|---|---|
| [JsonIntegration](-json-integration.md) | [jvm]<br>constructor() |

## Functions

| Name | Summary |
|---|---|
| [formatterAdapter](formatter-adapter.md) | [jvm]<br>abstract fun [formatterAdapter](formatter-adapter.md)(jsonStringAdapter: [JsonFormatter](../-json-formatter/index.md)&lt;*&gt;): [A](index.md)<br>Returns an adapter that applies [jsonStringAdapter](formatter-adapter.md) to each value. |
| [frameworkAdapter](framework-adapter.md) | [jvm]<br>abstract fun [frameworkAdapter](framework-adapter.md)(framework: [F](index.md), type: [Type](https://docs.oracle.com/javase/8/docs/api/java/lang/reflect/Type.html)): [A](index.md)<br>Returns [framework](framework-adapter.md)'s built-in adapter for [type](framework-adapter.md). |
| [jsonAdapters](json-adapters.md) | [jvm]<br>fun &lt;[M](json-adapters.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), [B](json-adapters.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [jsonAdapters](json-adapters.md)(adapter: [RuntimeMessageAdapter](../-runtime-message-adapter/index.md)&lt;[M](json-adapters.md), [B](json-adapters.md)&gt;, framework: [F](index.md)): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[A](index.md)&gt;<br>Returns a message type that supports encoding and decoding JSON objects of type type. |
| [listAdapter](list-adapter.md) | [jvm]<br>abstract fun [listAdapter](list-adapter.md)(elementAdapter: [A](index.md)): [A](index.md)<br>Returns an adapter iterates a list of the target adapter. |
| [mapAdapter](map-adapter.md) | [jvm]<br>abstract fun [mapAdapter](map-adapter.md)(framework: [F](index.md), keyFormatter: [JsonFormatter](../-json-formatter/index.md)&lt;*&gt;, valueAdapter: [A](index.md)): [A](index.md)<br>Returns an adapter iterates keys and values of the target adapter. |
| [structAdapter](struct-adapter.md) | [jvm]<br>abstract fun [structAdapter](struct-adapter.md)(framework: [F](index.md)): [A](index.md)<br>Returns an adapter that handles trees of Maps, Lists, and other JSON types. Should always serialize nulls, including when they are values in maps. |
