//[wire-runtime](../../../index.md)/[com.squareup.wire.internal](../index.md)/[LongArrayList](index.md)

# LongArrayList

[common]\
class [LongArrayList](index.md)(initialCapacity: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html))

Offers a nice wrapper around LongArray, that handles resizing the underlying array as needed and provides a trimToSize() method to truncate the underlying array to the current number of elements.

## Constructors

| | |
|---|---|
| [LongArrayList](-long-array-list.md) | [common]<br>constructor(initialCapacity: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)) |

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [common]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [add](add.md) | [common]<br>fun [add](add.md)(long: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)) |
| [isNotEmpty](is-not-empty.md) | [common]<br>fun [isNotEmpty](is-not-empty.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [toArray](to-array.md) | [common]<br>fun [toArray](to-array.md)(): [LongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long-array/index.html)<br>Returns the underlying LongArray, truncating as necessary so that the returned array has the same size as the number of elements in it. |
| [toString](to-string.md) | [common]<br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
