//[wire-runtime](../../../index.md)/[com.squareup.wire](../index.md)/[AnyMessage](index.md)

# AnyMessage

[common]\
class [AnyMessage](index.md)(val typeUrl: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val value: ByteString = ByteString.EMPTY) : [Message](../-message/index.md)&lt;[AnyMessage](index.md), [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)&gt; 

Wire implementation of the `google.protobuf.Any` type. The `Any` type wraps an arbitrary protobuf message. Field of `Any` generated by Wire will be typed [AnyMessage](index.md). [typeUrl](type-url.md) is used to identify the type of the message, defined as 'type.googleapis.com/full.type.name'. [value](value.md) is the serialized representation of the wrapped message. The [pack](-companion/pack.md) and [unpack](unpack.md) methods are available to wrap and unwrap an `Any` message.

Example

```kotlin
val person: Person = anyMessage.unpack(Person.ADAPTER)
val anyMessage: AnyMessage = AnyMessage.ADAPTER.pack(person)
```

## Constructors

| | |
|---|---|
| [AnyMessage](-any-message.md) | [common]<br>constructor(typeUrl: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), value: ByteString = ByteString.EMPTY) |

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [common]<br>object [Companion](-companion/index.md) |

## Properties

| Name | Summary |
|---|---|
| [adapter](../-message/adapter.md) | [common]<br>expect val [adapter](../-message/adapter.md): [ProtoAdapter](../-proto-adapter/index.md)&lt;[AnyMessage](index.md)&gt;<br>The [ProtoAdapter](../-proto-adapter/index.md) for encoding and decoding messages of this type. |
| [typeUrl](type-url.md) | [common]<br>val [typeUrl](type-url.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [unknownFields](../-message/unknown-fields.md) | [common]<br>expect val [unknownFields](../-message/unknown-fields.md): ByteString<br>Returns a byte string containing the proto encoding of this message's unknown fields. Returns an empty byte string if this message has no unknown fields. |
| [value](value.md) | [common]<br>val [value](value.md): ByteString |

## Functions

| Name | Summary |
|---|---|
| [copy](copy.md) | [common]<br>fun [copy](copy.md)(typeUrl: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) = this.typeUrl, value: ByteString = this.value): [AnyMessage](index.md) |
| [encode](../-message/encode.md) | [common]<br>expect fun [encode](../-message/encode.md)(): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>Encode this message as a `byte[]`.<br>[common]<br>expect fun [encode](../-message/encode.md)(sink: BufferedSink)<br>Encode this message and write it to `stream`. |
| [encodeByteString](../-message/encode-byte-string.md) | [common]<br>expect fun [encodeByteString](../-message/encode-byte-string.md)(): ByteString<br>Encode this message as a `ByteString`. |
| [equals](equals.md) | [common]<br>open operator override fun [equals](equals.md)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [hashCode](hash-code.md) | [common]<br>open override fun [hashCode](hash-code.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [toString](to-string.md) | [common]<br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [unpack](unpack.md) | [common]<br>fun &lt;[T](unpack.md)&gt; [unpack](unpack.md)(adapter: [ProtoAdapter](../-proto-adapter/index.md)&lt;[T](unpack.md)&gt;): [T](unpack.md) |
| [unpackOrNull](unpack-or-null.md) | [common]<br>fun &lt;[T](unpack-or-null.md)&gt; [unpackOrNull](unpack-or-null.md)(adapter: [ProtoAdapter](../-proto-adapter/index.md)&lt;[T](unpack-or-null.md)&gt;): [T](unpack-or-null.md)? |
