//[wire-runtime](../../../../index.md)/[com.squareup.wire](../../index.md)/[Message](../index.md)/[Builder](index.md)

# Builder

[common]\
expect abstract class [Builder](index.md)&lt;[M](index.md) : [Message](../index.md)&lt;[M](index.md), [B](index.md)&gt;, [B](index.md) : [Message.Builder](index.md)&lt;[M](index.md), [B](index.md)&gt;&gt;

Superclass for protocol buffer message builders.

[js, jvm, native]\
actual abstract class [Builder](index.md)&lt;[M](index.md) : [Message](../index.md)&lt;[M](index.md), [B](index.md)&gt;, [B](index.md) : [Message.Builder](index.md)&lt;[M](index.md), [B](index.md)&gt;&gt;

Superclass for protocol buffer message builders.

## Functions

| Name | Summary |
|---|---|
| [addUnknownField](add-unknown-field.md) | [common, js, jvm, native]<br>[common]<br>expect fun [addUnknownField](add-unknown-field.md)(tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), fieldEncoding: [FieldEncoding](../../-field-encoding/index.md), value: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Message.Builder](index.md)&lt;[M](index.md), [B](index.md)&gt;<br>[js, jvm, native]<br>actual fun [addUnknownField](add-unknown-field.md)(tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), fieldEncoding: [FieldEncoding](../../-field-encoding/index.md), value: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Message.Builder](index.md)&lt;[M](index.md), [B](index.md)&gt; |
| [addUnknownFields](add-unknown-fields.md) | [common, js, jvm, native]<br>[common]<br>expect fun [addUnknownFields](add-unknown-fields.md)(unknownFields: ByteString): [Message.Builder](index.md)&lt;[M](index.md), [B](index.md)&gt;<br>[js, jvm, native]<br>actual fun [addUnknownFields](add-unknown-fields.md)(unknownFields: ByteString): [Message.Builder](index.md)&lt;[M](index.md), [B](index.md)&gt; |
| [build](build.md) | [common]<br>expect abstract fun [build](build.md)(): [M](index.md)<br>Returns an immutable [Message](../index.md) based on the fields that set in this builder.<br>[js, jvm, native]<br>[js, jvm, native]<br>actual abstract fun [build](build.md)(): [M](index.md) |
| [buildUnknownFields](build-unknown-fields.md) | [common]<br>expect fun [buildUnknownFields](build-unknown-fields.md)(): ByteString<br>Returns a byte string with this message's unknown fields. Returns an empty byte string if this message has no unknown fields.<br>[js, jvm, native]<br>[js, jvm, native]<br>actual fun [buildUnknownFields](build-unknown-fields.md)(): ByteString |
| [clearUnknownFields](clear-unknown-fields.md) | [common, js, jvm, native]<br>[common]<br>expect fun [clearUnknownFields](clear-unknown-fields.md)(): [Message.Builder](index.md)&lt;[M](index.md), [B](index.md)&gt;<br>[js, jvm, native]<br>actual fun [clearUnknownFields](clear-unknown-fields.md)(): [Message.Builder](index.md)&lt;[M](index.md), [B](index.md)&gt; |
