//[wire-runtime](../../../index.md)/[com.squareup.wire](../index.md)/[OneOf](index.md)

# OneOf

[common]\
data class [OneOf](index.md)&lt;out [K](index.md) : [OneOf.Key](-key/index.md)&lt;[T](index.md)&gt;, [T](index.md)&gt;(val key: [K](index.md), val value: [T](index.md))

A oneof's value and the key that identifies which field holds it.

Wire has two different mechanisms for generating `oneof` code: “boxed” that uses this class, and “flat” where all oneof fields are defined inline in the declaring message.

Flat oneofs

 -----------

This is Wire's default mechanism. Each oneof field in the schema yields a field in the generated Kotlin or Java class. At most one field has a non-null value, and callers need to manually probe each field until they find the non-null value.

This is well-suited to oneofs with a small number of choices (less than 5).

Boxed oneofs

 ------------

In this mechanism the generated class has one field that holds an instance of this. It has both a key that identifies which field is populated, and its value. If no field is set, then the OneOf box is null.

This is well-suited to oneofs with a large number of choices (5 or more). This mechanism is necessary for oneofs with a very large number of options because in the other form the generated code may exceed the JVM's method size limits.

Opt-in to boxed oneofs in your build by setting the `boxOneOfsMinSize` option. OneOfs with this many fields or more will be generated in this form.

```kotlin
wire {
  kotlin {
    boxOneOfsMinSize = 10
  }
}
```

Using Boxed oneofs

 ------------------

One challenge in using oneofs is coping with data from different schema versions that offer new unknown choices. For example, a client may receive a message from a server that sets a oneof field the client doesn't know about; or a server may read an archived message with a oneof field that has since been deleted.

In either case, the oneof will be null! There is no way to differentiate between unset and set to an unknown field. Please keep this in mind when writing code to handle oneofs.

In this example the address type may be absent (no value was ever set) or its type may be too new for the current code to understand. This code returns a default value:

```kotlin
val buttonLabel = when (contact.address?.key) {
  Contact.addressSmsNumber -> "Send SMS"
  Contact.addressEmailAddress -> "Send Email"
  else -> "Address Type Unknown or Unset"
}
```

Another approach is to crash. In this case applications need to be careful to avoid receiving data with an incompatible schema.

```kotlin
val buttonLabel = when (contact.address?.key) {
  Contact.addressSmsNumber -> "Send SMS"
  Contact.addressEmailAddress -> "Send Email"
  else -> throw IllegalStateException("unknown address!")
}
```

Consider AnyMessage

 -------------------

New schemas should consider [google.protobuf.Any](../-any-message/index.md) instead of `oneof`.

Benefits of `Any`:

- 
   No build-time dependency from the referencing type on the referenced type.
- 
   Add new types without changing the schema

Benefits of `OneOf`:

- 
   More compact on-the-wire encoding. Approximately 1 byte of overhead for `OneOf` vs. `32` for     the message name in an `Any`.
- 
   All choices are cataloged a central place in the schema.

## Constructors

| | |
|---|---|
| [OneOf](-one-of.md) | [common]<br>constructor(key: [K](index.md), value: [T](index.md)) |

## Types

| Name | Summary |
|---|---|
| [Key](-key/index.md) | [common]<br>abstract class [Key](-key/index.md)&lt;[T](-key/index.md)&gt;(val tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), val adapter: [ProtoAdapter](../-proto-adapter/index.md)&lt;[T](-key/index.md)&gt;, val declaredName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val redacted: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, val jsonName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) = &quot;&quot;)<br>Identifies a field in a OneOf. Typically subclasses are generated by the Wire compiler and instances are declared as members of the referencing message class. |

## Properties

| Name | Summary |
|---|---|
| [key](key.md) | [common]<br>val [key](key.md): [K](index.md) |
| [value](value.md) | [common]<br>val [value](value.md): [T](index.md) |

## Functions

| Name | Summary |
|---|---|
| [encodedSizeWithTag](encoded-size-with-tag.md) | [common]<br>fun [encodedSizeWithTag](encoded-size-with-tag.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [encodeWithTag](encode-with-tag.md) | [common]<br>fun [encodeWithTag](encode-with-tag.md)(writer: [ProtoWriter](../-proto-writer/index.md))<br>fun [encodeWithTag](encode-with-tag.md)(writer: [ReverseProtoWriter](../-reverse-proto-writer/index.md)) |
| [getOrNull](get-or-null.md) | [common]<br>fun &lt;[X](get-or-null.md)&gt; [getOrNull](get-or-null.md)(key: [OneOf.Key](-key/index.md)&lt;[X](get-or-null.md)&gt;): [X](get-or-null.md)? |
| [toString](to-string.md) | [common]<br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
