//[wire-runtime](../../../index.md)/[com.squareup.wire](../index.md)/[ProtoAdapter](index.md)

# ProtoAdapter

expect abstract class [ProtoAdapter](index.md)&lt;[E](index.md)[E](index.md)[E](index.md)[E](index.md)&gt;(fieldEncoding: [FieldEncoding](../-field-encoding/index.md), type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;?, typeUrl: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, syntax: [Syntax](../-syntax/index.md), identity: [E](index.md)? = null, sourceFile: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? = null)actual abstract class [ProtoAdapter](index.md)&lt;[E](index.md)[E](index.md)[E](index.md)[E](index.md)&gt;(fieldEncoding: [FieldEncoding](../-field-encoding/index.md), val type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;?, val typeUrl: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, val syntax: [Syntax](../-syntax/index.md), val identity: [E](index.md)?, val sourceFile: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?)actual abstract class [ProtoAdapter](index.md)&lt;[E](index.md)[E](index.md)[E](index.md)[E](index.md)&gt;(fieldEncoding: [FieldEncoding](../-field-encoding/index.md), val type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;?, val typeUrl: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, val syntax: [Syntax](../-syntax/index.md), val identity: [E](index.md)?, val sourceFile: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?)actual abstract class [ProtoAdapter](index.md)&lt;[E](index.md)[E](index.md)[E](index.md)[E](index.md)&gt;(fieldEncoding: [FieldEncoding](../-field-encoding/index.md), val type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;?, val typeUrl: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, val syntax: [Syntax](../-syntax/index.md), val identity: [E](index.md)?, val sourceFile: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?)

#### Inheritors

| |
|---|
| [EnumAdapter](../-enum-adapter/index.md) |
| [RuntimeMessageAdapter](../../com.squareup.wire.internal/-runtime-message-adapter/index.md) |
| [EnumAdapter](../-enum-adapter/index.md) |
| [UnsupportedTypeProtoAdapter](-companion/-unsupported-type-proto-adapter/index.md) |
| [EnumAdapter](../-enum-adapter/index.md) |
| [EnumAdapter](../-enum-adapter/index.md) |

## Constructors

| | |
|---|---|
| [ProtoAdapter](-proto-adapter.md) | [jvm]<br>constructor(fieldEncoding: [FieldEncoding](../-field-encoding/index.md), type: [Class](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)&lt;*&gt;)constructor(fieldEncoding: [FieldEncoding](../-field-encoding/index.md), type: [Class](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)&lt;*&gt;, typeUrl: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?)constructor(fieldEncoding: [FieldEncoding](../-field-encoding/index.md), type: [Class](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)&lt;*&gt;, typeUrl: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, syntax: [Syntax](../-syntax/index.md))constructor(fieldEncoding: [FieldEncoding](../-field-encoding/index.md), type: [Class](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)&lt;*&gt;, typeUrl: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, syntax: [Syntax](../-syntax/index.md), identity: [E](index.md)?)constructor(fieldEncoding: [FieldEncoding](../-field-encoding/index.md), type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;?)constructor(fieldEncoding: [FieldEncoding](../-field-encoding/index.md), type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;?, typeUrl: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?)constructor(fieldEncoding: [FieldEncoding](../-field-encoding/index.md), type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;?, typeUrl: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, syntax: [Syntax](../-syntax/index.md))constructor(fieldEncoding: [FieldEncoding](../-field-encoding/index.md), type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;?, typeUrl: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, syntax: [Syntax](../-syntax/index.md), identity: [E](index.md)?)constructor(fieldEncoding: [FieldEncoding](../-field-encoding/index.md), type: [Class](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)&lt;*&gt;, typeUrl: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, syntax: [Syntax](../-syntax/index.md), identity: [E](index.md)?, sourceFile: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?)actual constructor(fieldEncoding: [FieldEncoding](../-field-encoding/index.md), type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;?, typeUrl: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, syntax: [Syntax](../-syntax/index.md), identity: [E](index.md)?, sourceFile: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?)<br>[common]<br>expect constructor(fieldEncoding: [FieldEncoding](../-field-encoding/index.md), type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;?, typeUrl: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, syntax: [Syntax](../-syntax/index.md), identity: [E](index.md)? = null, sourceFile: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? = null)<br>[js, native]<br>actual constructor(fieldEncoding: [FieldEncoding](../-field-encoding/index.md), type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;?, typeUrl: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, syntax: [Syntax](../-syntax/index.md), identity: [E](index.md)?, sourceFile: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?) |

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [common, js, jvm, native]<br>[common]<br>expect object [Companion](-companion/index.md)<br>[js, jvm, native]<br>actual object [Companion](-companion/index.md) |
| [EnumConstantNotFoundException](-enum-constant-not-found-exception/index.md) | [common, js, jvm, native]<br>[common]<br>expect class [EnumConstantNotFoundException](-enum-constant-not-found-exception/index.md)(value: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;?) : [IllegalArgumentException](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-illegal-argument-exception/index.html)<br>[js, native]<br>actual class [EnumConstantNotFoundException](-enum-constant-not-found-exception/index.md)(val value: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;?) : [IllegalArgumentException](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-illegal-argument-exception/index.html)<br>[jvm]<br>actual class [EnumConstantNotFoundException](-enum-constant-not-found-exception/index.md)(val value: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;?) : [IllegalArgumentException](https://docs.oracle.com/javase/8/docs/api/java/lang/IllegalArgumentException.html) |

## Properties

| Name | Summary |
|---|---|
| [identity](identity.md) | [common]<br>expect val [identity](identity.md): [E](index.md)?<br>A special value that is used when a field is absent from an encoded proto3 message. When encoding a proto3 message, fields that hold this value will be omitted.<br>[js, jvm, native]<br>[js, jvm, native]<br>actual val [identity](identity.md): [E](index.md)? |
| [sourceFile](source-file.md) | [common]<br>expect val [sourceFile](source-file.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?<br>Path to the file containing the protobuf definition of this type.<br>[js, jvm, native]<br>[js, jvm, native]<br>actual val [sourceFile](source-file.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |
| [syntax](syntax.md) | [common]<br>expect val [syntax](syntax.md): [Syntax](../-syntax/index.md)<br>Identifies the syntax in which [type](type.md) is defined in the proto schema. This string contains either &quot;proto2&quot; or &quot;proto3&quot;.<br>[js, jvm, native]<br>[js, jvm, native]<br>actual val [syntax](syntax.md): [Syntax](../-syntax/index.md) |
| [type](type.md) | [common, js, jvm, native]<br>[common]<br>expect val [type](type.md): [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;?<br>[js, jvm, native]<br>actual val [type](type.md): [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;? |
| [typeUrl](type-url.md) | [common]<br>expect val [typeUrl](type-url.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?<br>Identifies this type for inclusion in a `google.protobuf.Any`. This is a string like &quot;type.googleapis.com/packagename.messagename&quot; or null if this type is either not a message (such as scalars and enums), or was code-generated before Wire 3.2 which introduced support for type URLS.<br>[js, jvm, native]<br>[js, jvm, native]<br>actual val [typeUrl](type-url.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |

## Functions

| Name | Summary |
|---|---|
| [asPacked](as-packed.md) | [common, js, native]<br>[common]<br>expect fun [asPacked](as-packed.md)(): [ProtoAdapter](index.md)&lt;[List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[E](index.md)&gt;&gt;<br>[js, native]<br>actual fun [asPacked](as-packed.md)(): [ProtoAdapter](index.md)&lt;[List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[E](index.md)&gt;&gt;<br>Returns an adapter for `E` but as a packed, repeated value.<br>[jvm]<br>actual fun [asPacked](as-packed.md)(): [ProtoAdapter](index.md)&lt;[List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[E](index.md)&gt;&gt; |
| [asRepeated](as-repeated.md) | [common, js, native]<br>[common]<br>expect fun [asRepeated](as-repeated.md)(): [ProtoAdapter](index.md)&lt;[List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[E](index.md)&gt;&gt;<br>[js, native]<br>actual fun [asRepeated](as-repeated.md)(): [ProtoAdapter](index.md)&lt;[List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[E](index.md)&gt;&gt;<br>Returns an adapter for `E` but as a repeated value.<br>[jvm]<br>actual fun [asRepeated](as-repeated.md)(): [ProtoAdapter](index.md)&lt;[List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[E](index.md)&gt;&gt; |
| [decode](decode.md) | [common, js, native]<br>[common]<br>expect abstract fun [decode](decode.md)(reader: [ProtoReader](../-proto-reader/index.md)): [E](index.md)<br>[js, native]<br>actual abstract fun [decode](decode.md)(reader: [ProtoReader](../-proto-reader/index.md)): [E](index.md)<br>Read a non-null value from `reader`.<br>[jvm]<br>actual abstract fun [decode](decode.md)(reader: [ProtoReader](../-proto-reader/index.md)): [E](index.md)<br>fun [decode](decode.md)(stream: [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html)): [E](index.md)<br>actual fun [decode](decode.md)(bytes: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [E](index.md)<br>actual fun [decode](decode.md)(source: BufferedSource): [E](index.md)<br>actual fun [decode](decode.md)(bytes: ByteString): [E](index.md)<br>[common, js, native]<br>[common]<br>expect fun [decode](decode.md)(bytes: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [E](index.md)<br>[js, native]<br>actual fun [decode](decode.md)(bytes: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [E](index.md)<br>[common]<br>expect fun [decode](decode.md)(bytes: ByteString): [E](index.md)<br>[js, native]<br>actual fun [decode](decode.md)(bytes: ByteString): [E](index.md)<br>Read an encoded message from `bytes`.<br>[common, js, native]<br>[common]<br>expect fun [decode](decode.md)(source: BufferedSource): [E](index.md)<br>[js, native]<br>actual fun [decode](decode.md)(source: BufferedSource): [E](index.md)<br>Read an encoded message from `source`. |
| [decode](../decode.md) | [darwin]<br>@[ExperimentalUnsignedTypes](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-experimental-unsigned-types/index.html)<br>fun &lt;[E](../decode.md)&gt; [ProtoAdapter](index.md)&lt;[E](../decode.md)&gt;.[decode](../decode.md)(data: NSData): [E](../decode.md)<br>Read an encoded message from `data`. |
| [encode](encode.md) | [common, js, native]<br>[common]<br>expect fun [encode](encode.md)(value: [E](index.md)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>[js, native]<br>actual fun [encode](encode.md)(value: [E](index.md)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>Encode `value` as a `byte[]`.<br>[jvm]<br>actual fun [encode](encode.md)(value: [E](index.md)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>actual abstract fun [encode](encode.md)(writer: [ProtoWriter](../-proto-writer/index.md), value: [E](index.md))<br>actual open fun [encode](encode.md)(writer: [ReverseProtoWriter](../-reverse-proto-writer/index.md), value: [E](index.md))<br>fun [encode](encode.md)(stream: [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html), value: [E](index.md))<br>actual fun [encode](encode.md)(sink: BufferedSink, value: [E](index.md))<br>[common, js, native]<br>[common]<br>expect abstract fun [encode](encode.md)(writer: [ProtoWriter](../-proto-writer/index.md), value: [E](index.md))<br>[js, native]<br>actual abstract fun [encode](encode.md)(writer: [ProtoWriter](../-proto-writer/index.md), value: [E](index.md))<br>[common]<br>expect open fun [encode](encode.md)(writer: [ReverseProtoWriter](../-reverse-proto-writer/index.md), value: [E](index.md))<br>[js, native]<br>actual open fun [encode](encode.md)(writer: [ReverseProtoWriter](../-reverse-proto-writer/index.md), value: [E](index.md))<br>Write non-null `value` to `writer`.<br>[common, js, native]<br>[common]<br>expect fun [encode](encode.md)(sink: BufferedSink, value: [E](index.md))<br>[js, native]<br>actual fun [encode](encode.md)(sink: BufferedSink, value: [E](index.md))<br>Encode `value` and write it to `stream`. |
| [encodeByteString](encode-byte-string.md) | [common, js, native]<br>[common]<br>expect fun [encodeByteString](encode-byte-string.md)(value: [E](index.md)): ByteString<br>[js, native]<br>actual fun [encodeByteString](encode-byte-string.md)(value: [E](index.md)): ByteString<br>Encode `value` as a ByteString.<br>[jvm]<br>actual fun [encodeByteString](encode-byte-string.md)(value: [E](index.md)): ByteString |
| [encodedSize](encoded-size.md) | [common, js, native]<br>[common]<br>expect abstract fun [encodedSize](encoded-size.md)(value: [E](index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[js, native]<br>actual abstract fun [encodedSize](encoded-size.md)(value: [E](index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>The size of the non-null data `value`. This does not include the size required for a length-delimited prefix (should the type require one).<br>[jvm]<br>actual abstract fun [encodedSize](encoded-size.md)(value: [E](index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [encodedSizeWithTag](encoded-size-with-tag.md) | [common, js, native]<br>[common]<br>expect open fun [encodedSizeWithTag](encoded-size-with-tag.md)(tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[js, native]<br>actual open fun [encodedSizeWithTag](encoded-size-with-tag.md)(tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>The size of `tag` and `value` in the wire format. This size includes the tag, type, length-delimited prefix (should the type require one), and value. Returns 0 if `value` is null.<br>[jvm]<br>actual open fun [encodedSizeWithTag](encoded-size-with-tag.md)(tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [encodeWithTag](encode-with-tag.md) | [common, js, native]<br>[common]<br>expect open fun [encodeWithTag](encode-with-tag.md)(writer: [ProtoWriter](../-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?)<br>[js, native]<br>actual open fun [encodeWithTag](encode-with-tag.md)(writer: [ProtoWriter](../-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?)<br>[common]<br>expect open fun [encodeWithTag](encode-with-tag.md)(writer: [ReverseProtoWriter](../-reverse-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?)<br>[js, native]<br>actual open fun [encodeWithTag](encode-with-tag.md)(writer: [ReverseProtoWriter](../-reverse-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?)<br>Write `tag` and `value` to `writer`. If value is null this does nothing.<br>[jvm]<br>actual open fun [encodeWithTag](encode-with-tag.md)(writer: [ProtoWriter](../-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?)<br>actual open fun [encodeWithTag](encode-with-tag.md)(writer: [ReverseProtoWriter](../-reverse-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?) |
| [redact](redact.md) | [common, js, native]<br>[common]<br>expect abstract fun [redact](redact.md)(value: [E](index.md)): [E](index.md)<br>[js, native]<br>actual abstract fun [redact](redact.md)(value: [E](index.md)): [E](index.md)<br>Returns the redacted form of `value`.<br>[jvm]<br>actual abstract fun [redact](redact.md)(value: [E](index.md)): [E](index.md) |
| [toString](to-string.md) | [common, js, native]<br>[common]<br>expect open fun [toString](to-string.md)(value: [E](index.md)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[js, native]<br>actual open fun [toString](to-string.md)(value: [E](index.md)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns a human-readable version of the given `value`.<br>[jvm]<br>actual open fun [toString](to-string.md)(value: [E](index.md)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [tryDecode](try-decode.md) | [common]<br>expect fun [tryDecode](try-decode.md)(reader: [ProtoReader](../-proto-reader/index.md), destination: [MutableList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)&lt;[E](index.md)&gt;)<br>Reads a value and appends it to [destination](try-decode.md) if this has data available. Otherwise, it will only clear the reader state.<br>[js, jvm, native]<br>[js, jvm, native]<br>actual fun [tryDecode](try-decode.md)(reader: [ProtoReader](../-proto-reader/index.md), destination: [MutableList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)&lt;[E](index.md)&gt;) |
