//[wire-runtime](../../../index.md)/[com.squareup.wire](../index.md)/[WireRpc](index.md)

# WireRpc

[common]\
@[Target](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.annotation/-target/index.html)(allowedTargets = [[AnnotationTarget.FUNCTION](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.annotation/-annotation-target/-f-u-n-c-t-i-o-n/index.html)])

annotation class [WireRpc](index.md)(val path: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val requestAdapter: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val responseAdapter: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val sourceFile: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) = &quot;&quot;)

For gRPC actions the path is formatted as `/<service name>/<method name>`. The path of the proto service below is `/squareup.helloworld.Greeter/SayHello`.

```kotlin
package squareup.helloworld;

service Greeter {
  rpc SayHello (HelloRequest) returns (HelloReply) {}
}
```

## Properties

| Name | Summary |
|---|---|
| [path](path.md) | [common]<br>val [path](path.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [requestAdapter](request-adapter.md) | [common]<br>val [requestAdapter](request-adapter.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [responseAdapter](response-adapter.md) | [common]<br>val [responseAdapter](response-adapter.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [sourceFile](source-file.md) | [common]<br>val [sourceFile](source-file.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
