//[wire-runtime](../../../index.md)/[com.squareup.wire.internal](../index.md)/[DurationJsonFormatter](index.md)

# DurationJsonFormatter

[jvm]\
object [DurationJsonFormatter](index.md) : [JsonFormatter](../-json-formatter/index.md)&lt;[Duration](../../com.squareup.wire/-duration/index.md)&gt; 

Encode a duration as a JSON string like &quot;1.200s&quot;. From the spec:

Generated output always contains 0, 3, 6, or 9 fractional digits, depending on required precision, followed by the suffix &quot;s&quot;. Accepted are any fractional digits (also none) as long as they fit into nano-seconds precision and the suffix &quot;s&quot; is required.

Note that [Duration](../../com.squareup.wire/-duration/index.md) always returns a positive nanosPart, so &quot;-1.200s&quot; is represented as -2 seconds and 800_000_000 nanoseconds.

## Functions

| Name | Summary |
|---|---|
| [fromString](from-string.md) | [jvm]<br>open override fun [fromString](from-string.md)(value: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Duration](../../com.squareup.wire/-duration/index.md)<br>Throws a NumberFormatException if the string isn't a number like &quot;1s&quot; or &quot;1.23456789s&quot;. |
| [toStringOrNumber](to-string-or-number.md) | [jvm]<br>open override fun [toStringOrNumber](to-string-or-number.md)(value: [Duration](../../com.squareup.wire/-duration/index.md)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns either a String or a Number. |
