//[wire-runtime](../../../index.md)/[com.squareup.wire.internal](../index.md)/[RuntimeMessageAdapter](index.md)

# RuntimeMessageAdapter

[common]\
class [RuntimeMessageAdapter](index.md)&lt;[M](index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), [B](index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;(binding: [MessageBinding](../-message-binding/index.md)&lt;[M](index.md), [B](index.md)&gt;) : [ProtoAdapter](../../com.squareup.wire/-proto-adapter/index.md)&lt;[M](index.md)&gt;

## Constructors

| | |
|---|---|
| [RuntimeMessageAdapter](-runtime-message-adapter.md) | [common]<br>constructor(binding: [MessageBinding](../-message-binding/index.md)&lt;[M](index.md), [B](index.md)&gt;) |

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [common]<br>object [Companion](-companion/index.md) |

## Properties

| Name | Summary |
|---|---|
| [fieldBindingsArray](field-bindings-array.md) | [common]<br>val [fieldBindingsArray](field-bindings-array.md): [Array](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-array/index.html)&lt;[FieldOrOneOfBinding](../-field-or-one-of-binding/index.md)&lt;[M](index.md), [B](index.md)&gt;&gt;<br>Field bindings by index. The indexes are consistent across all related fields including [jsonNames](json-names.md), [jsonAlternateNames](json-alternate-names.md), and the result of jsonAdapters. |
| [fields](fields.md) | [common]<br>val [fields](fields.md): [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)&lt;[Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), [FieldOrOneOfBinding](../-field-or-one-of-binding/index.md)&lt;[M](index.md), [B](index.md)&gt;&gt; |
| [identity](../../com.squareup.wire/-proto-adapter/identity.md) | [common]<br>expect val [identity](../../com.squareup.wire/-proto-adapter/identity.md): [M](index.md)?<br>A special value that is used when a field is absent from an encoded proto3 message. When encoding a proto3 message, fields that hold this value will be omitted. |
| [jsonAlternateNames](json-alternate-names.md) | [common]<br>val [jsonAlternateNames](json-alternate-names.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?&gt;<br>When reading JSON these are alternate names for each field. If null the field has no alternate name. |
| [jsonName](json-name.md) | [common]<br>val [FieldOrOneOfBinding](../-field-or-one-of-binding/index.md)&lt;*, *&gt;.[jsonName](json-name.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>When writing each field as JSON this is the name to use. |
| [jsonNames](json-names.md) | [common]<br>val [jsonNames](json-names.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt; |
| [sourceFile](../../com.squareup.wire/-proto-adapter/source-file.md) | [common]<br>expect val [sourceFile](../../com.squareup.wire/-proto-adapter/source-file.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?<br>Path to the file containing the protobuf definition of this type. |
| [syntax](../../com.squareup.wire/-proto-adapter/syntax.md) | [common]<br>expect val [syntax](../../com.squareup.wire/-proto-adapter/syntax.md): [Syntax](../../com.squareup.wire/-syntax/index.md)<br>Identifies the syntax in which [type](../../com.squareup.wire/-proto-adapter/type.md) is defined in the proto schema. This string contains either &quot;proto2&quot; or &quot;proto3&quot;. |
| [type](../../com.squareup.wire/-proto-adapter/type.md) | [common]<br>expect val [type](../../com.squareup.wire/-proto-adapter/type.md): [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;? |
| [typeUrl](../../com.squareup.wire/-proto-adapter/type-url.md) | [common]<br>expect val [typeUrl](../../com.squareup.wire/-proto-adapter/type-url.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?<br>Identifies this type for inclusion in a `google.protobuf.Any`. This is a string like &quot;type.googleapis.com/packagename.messagename&quot; or null if this type is either not a message (such as scalars and enums), or was code-generated before Wire 3.2 which introduced support for type URLS. |

## Functions

| Name | Summary |
|---|---|
| [asPacked](../../com.squareup.wire/-proto-adapter/as-packed.md) | [common]<br>expect fun [asPacked](../../com.squareup.wire/-proto-adapter/as-packed.md)(): [ProtoAdapter](../../com.squareup.wire/-proto-adapter/index.md)&lt;[List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[M](index.md)&gt;&gt;<br>Returns an adapter for `E` but as a packed, repeated value. |
| [asRepeated](../../com.squareup.wire/-proto-adapter/as-repeated.md) | [common]<br>expect fun [asRepeated](../../com.squareup.wire/-proto-adapter/as-repeated.md)(): [ProtoAdapter](../../com.squareup.wire/-proto-adapter/index.md)&lt;[List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[M](index.md)&gt;&gt;<br>Returns an adapter for `E` but as a repeated value. |
| [decode](../../com.squareup.wire/-proto-adapter/decode.md) | [common]<br>expect fun [decode](../../com.squareup.wire/-proto-adapter/decode.md)(bytes: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [M](index.md)<br>expect fun [decode](../../com.squareup.wire/-proto-adapter/decode.md)(bytes: ByteString): [M](index.md)<br>Read an encoded message from `bytes`.<br>[common]<br>expect fun [decode](../../com.squareup.wire/-proto-adapter/decode.md)(source: BufferedSource): [M](index.md)<br>Read an encoded message from `source`.<br>[common]<br>open override fun [decode](decode.md)(reader: [ProtoReader](../../com.squareup.wire/-proto-reader/index.md)): [M](index.md)<br>Read a non-null value from `reader`. |
| [decode](../../com.squareup.wire/decode.md) | [darwin]<br>@[ExperimentalUnsignedTypes](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-experimental-unsigned-types/index.html)<br>fun &lt;[E](../../com.squareup.wire/decode.md)&gt; [ProtoAdapter](../../com.squareup.wire/-proto-adapter/index.md)&lt;[E](../../com.squareup.wire/decode.md)&gt;.[decode](../../com.squareup.wire/decode.md)(data: NSData): [E](../../com.squareup.wire/decode.md)<br>Read an encoded message from `data`. |
| [encode](index.md#571806861%2FFunctions%2F-1082500773) | [common]<br>expect fun [encode](index.md#571806861%2FFunctions%2F-1082500773)(value: [M](index.md)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>Encode `value` as a `byte[]`.<br>[common]<br>expect fun [encode](index.md#292685480%2FFunctions%2F-1082500773)(sink: BufferedSink, value: [M](index.md))<br>Encode `value` and write it to `stream`.<br>[common]<br>open override fun [encode](encode.md)(writer: [ProtoWriter](../../com.squareup.wire/-proto-writer/index.md), value: [M](index.md))<br>open override fun [encode](encode.md)(writer: [ReverseProtoWriter](../../com.squareup.wire/-reverse-proto-writer/index.md), value: [M](index.md))<br>Write non-null `value` to `writer`. |
| [encodeByteString](index.md#-460132012%2FFunctions%2F-1082500773) | [common]<br>expect fun [encodeByteString](index.md#-460132012%2FFunctions%2F-1082500773)(value: [M](index.md)): ByteString<br>Encode `value` as a ByteString. |
| [encodedSize](encoded-size.md) | [common]<br>open override fun [encodedSize](encoded-size.md)(value: [M](index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>The size of the non-null data `value`. This does not include the size required for a length-delimited prefix (should the type require one). |
| [encodedSizeWithTag](index.md#-1738198298%2FFunctions%2F-1082500773) | [common]<br>expect open fun [encodedSizeWithTag](index.md#-1738198298%2FFunctions%2F-1082500773)(tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [M](index.md)?): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>The size of `tag` and `value` in the wire format. This size includes the tag, type, length-delimited prefix (should the type require one), and value. Returns 0 if `value` is null. |
| [encodeWithTag](index.md#-2067282125%2FFunctions%2F-1082500773) | [common]<br>expect open fun [encodeWithTag](index.md#-2067282125%2FFunctions%2F-1082500773)(writer: [ProtoWriter](../../com.squareup.wire/-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [M](index.md)?)<br>expect open fun [encodeWithTag](index.md#-1655678809%2FFunctions%2F-1082500773)(writer: [ReverseProtoWriter](../../com.squareup.wire/-reverse-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [M](index.md)?)<br>Write `tag` and `value` to `writer`. If value is null this does nothing. |
| [equals](equals.md) | [common]<br>open operator override fun [equals](equals.md)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [hashCode](hash-code.md) | [common]<br>open override fun [hashCode](hash-code.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [newBuilder](new-builder.md) | [common]<br>fun [newBuilder](new-builder.md)(): [B](index.md) |
| [redact](redact.md) | [common]<br>open override fun [redact](redact.md)(value: [M](index.md)): [M](index.md)<br>Returns the redacted form of `value`. |
| [toString](to-string.md) | [common]<br>open override fun [toString](to-string.md)(value: [M](index.md)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns a human-readable version of the given `value`. |
| [tryDecode](index.md#-1932810218%2FFunctions%2F-1082500773) | [common]<br>expect fun [tryDecode](index.md#-1932810218%2FFunctions%2F-1082500773)(reader: [ProtoReader](../../com.squareup.wire/-proto-reader/index.md), destination: [MutableList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)&lt;[M](index.md)&gt;)<br>Reads a value and appends it to [destination](index.md#-1932810218%2FFunctions%2F-1082500773) if this has data available. Otherwise, it will only clear the reader state. |
| [writeAllFields](write-all-fields.md) | [common]<br>fun &lt;[A](write-all-fields.md)&gt; [writeAllFields](write-all-fields.md)(message: [M](index.md)?, jsonAdapters: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[A](write-all-fields.md)&gt;, redactedFieldsAdapter: [A](write-all-fields.md)?, encodeValue: ([String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, [A](write-all-fields.md)) -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))<br>Walk the fields of [message](write-all-fields.md) and invoke [encodeValue](write-all-fields.md) on each that should be written as JSON. This omits fields that have the identity value when that is required. |
