//[wire-runtime](../../../index.md)/[com.squareup.wire.internal](../index.md)/[RuntimeMessageAdapter](index.md)/[jsonAlternateNames](json-alternate-names.md)

# jsonAlternateNames

[common]\
val [jsonAlternateNames](json-alternate-names.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?&gt;

When reading JSON these are alternate names for each field. If null the field has no alternate name.

For reserved keywords in Kotlin or Java, a field like `public` are written as so although the generated field name is `public_`. We want to read in either form. As well, in proto3 fields declared in snake_case like `customer_id` are written in camelCase like `customerId`, but can be read in either form. We can use exclusive logic between the two cases because there's no keyword defined in snake_case. The alternate name will be absent if the field name isn't a keyword or if the snake and camel cases are the same, such as in single-word identifiers. Lastly, in order to deserialize camelCased field from proto2, we add a camelCase alternative if the `jsonName` doesn't already match it.
