//[wire-runtime](../../index.md)/[com.squareup.wire.internal](index.md)

# Package-level declarations

## Types

| Name | Summary |
|---|---|
| [DoubleArrayList](-double-array-list/index.md) | [common]<br>class [DoubleArrayList](-double-array-list/index.md)(initialCapacity: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html))<br>Offers a nice wrapper around DoubleArray, that handles resizing the underlying array as needed and provides a trimToSize() method to truncate the underlying array to the current number of elements. |
| [DurationJsonFormatter](-duration-json-formatter/index.md) | [jvm]<br>object [DurationJsonFormatter](-duration-json-formatter/index.md) : [JsonFormatter](-json-formatter/index.md)&lt;[Duration](../com.squareup.wire/-duration/index.md)&gt; <br>Encode a duration as a JSON string like &quot;1.200s&quot;. From the spec: |
| [EnumJsonFormatter](-enum-json-formatter/index.md) | [jvm]<br>class [EnumJsonFormatter](-enum-json-formatter/index.md)&lt;[E](-enum-json-formatter/index.md) : [WireEnum](../com.squareup.wire/-wire-enum/index.md)&gt;(adapter: [EnumAdapter](../com.squareup.wire/-enum-adapter/index.md)&lt;[E](-enum-json-formatter/index.md)&gt;) : [JsonFormatter](-json-formatter/index.md)&lt;[E](-enum-json-formatter/index.md)&gt; <br>Encodes enums using their declared names as defined in [WireEnumConstant](../com.squareup.wire/-wire-enum-constant/index.md) or their generated names if the declared name is empty. Decodes using either their declared names, their generated names, or their tags. |
| [FieldBinding](-field-binding/index.md) | [jvm]<br>class [FieldBinding](-field-binding/index.md)&lt;[M](-field-binding/index.md) : [Message](../com.squareup.wire/-message/index.md)&lt;[M](-field-binding/index.md), [B](-field-binding/index.md)&gt;, [B](-field-binding/index.md) : [Message.Builder](../com.squareup.wire/-message/-builder/index.md)&lt;[M](-field-binding/index.md), [B](-field-binding/index.md)&gt;&gt; : [FieldOrOneOfBinding](-field-or-one-of-binding/index.md)&lt;[M](-field-binding/index.md), [B](-field-binding/index.md)&gt; <br>Read, write, and describe a tag within a message. This class knows how to assign fields to a builder object, and how to extract values from a message object. |
| [FieldOrOneOfBinding](-field-or-one-of-binding/index.md) | [common]<br>abstract class [FieldOrOneOfBinding](-field-or-one-of-binding/index.md)&lt;[M](-field-or-one-of-binding/index.md), [B](-field-or-one-of-binding/index.md)&gt; |
| [FloatArrayList](-float-array-list/index.md) | [common]<br>class [FloatArrayList](-float-array-list/index.md)(initialCapacity: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html))<br>Offers a nice wrapper around FloatArray, that handles resizing the underlying array as needed and provides a trimToSize() method to truncate the underlying array to the current number of elements. |
| [InstantJsonFormatter](-instant-json-formatter/index.md) | [jvm]<br>object [InstantJsonFormatter](-instant-json-formatter/index.md) : [JsonFormatter](-json-formatter/index.md)&lt;[Instant](../com.squareup.wire/-instant/index.md)&gt; <br>Encode an instant as a JSON string like &quot;1950-01-01T00:00:00Z&quot;. From the spec: |
| [IntArrayList](-int-array-list/index.md) | [common]<br>class [IntArrayList](-int-array-list/index.md)(initialCapacity: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html))<br>Offers a nice wrapper around IntArray, that handles resizing the underlying array as needed and provides a trimToSize() method to truncate the underlying array to the current number of elements. |
| [JsonFormatter](-json-formatter/index.md) | [jvm]<br>interface [JsonFormatter](-json-formatter/index.md)&lt;[W](-json-formatter/index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;<br>Transforms a scalar value to and from JSON. |
| [JsonIntegration](-json-integration/index.md) | [jvm]<br>abstract class [JsonIntegration](-json-integration/index.md)&lt;[F](-json-integration/index.md), [A](-json-integration/index.md)&gt;<br>Integrates a JSON library like Moshi or Gson into proto. This rigid interface attempts to make it easy all JSON libraries to encode and decode JSON in the exact same way. |
| [JvmDefaultWithCompatibility](-jvm-default-with-compatibility/index.md) | [common, jvm]<br>[common]<br>expect annotation class [JvmDefaultWithCompatibility](-jvm-default-with-compatibility/index.md)<br>[jvm]<br>actual typealias [JvmDefaultWithCompatibility](-jvm-default-with-compatibility/index.md) = [kotlin.jvm.JvmDefaultWithCompatibility](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-default-with-compatibility/index.html) |
| [JvmField](-jvm-field/index.md) | [common, jvm]<br>[common]<br>expect annotation class [JvmField](-jvm-field/index.md)<br>[jvm]<br>actual typealias [JvmField](-jvm-field/index.md) = [kotlin.jvm.JvmField](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-field/index.html)<br>[js, native]<br>[js, native]<br>actual annotation class [JvmField](-jvm-field/index.md)<br>This annotation is an empty placeholder. |
| [JvmStatic](-jvm-static/index.md) | [common, jvm]<br>[common]<br>expect annotation class [JvmStatic](-jvm-static/index.md)<br>[jvm]<br>actual typealias [JvmStatic](-jvm-static/index.md) = [kotlin.jvm.JvmStatic](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-static/index.html)<br>[js, native]<br>[js, native]<br>actual annotation class [JvmStatic](-jvm-static/index.md)<br>This annotation is an empty placeholder. |
| [LongArrayList](-long-array-list/index.md) | [common]<br>class [LongArrayList](-long-array-list/index.md)(initialCapacity: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html))<br>Offers a nice wrapper around LongArray, that handles resizing the underlying array as needed and provides a trimToSize() method to truncate the underlying array to the current number of elements. |
| [MessageBinding](-message-binding/index.md) | [common]<br>interface [MessageBinding](-message-binding/index.md)&lt;[M](-message-binding/index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), [B](-message-binding/index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;<br>A representation of a message and its builder class. Typically these are generated subtypes of [com.squareup.wire.Message](../com.squareup.wire/-message/index.md) and [com.squareup.wire.Message.Builder](../com.squareup.wire/-message/-builder/index.md). |
| [ObjectStreamException](-object-stream-exception/index.md) | [common, js, native, jvm]<br>[common]<br>expect abstract class [ObjectStreamException](-object-stream-exception/index.md) : IOException<br>[js, native]<br>actual abstract class [ObjectStreamException](-object-stream-exception/index.md) : IOException<br>[jvm]<br>actual typealias [ObjectStreamException](-object-stream-exception/index.md) = [java.io.ObjectStreamException](https://docs.oracle.com/javase/8/docs/api/java/io/ObjectStreamException.html) |
| [ProtocolException](-protocol-exception/index.md) | [common, js, native, jvm]<br>[common]<br>expect class [ProtocolException](-protocol-exception/index.md)(host: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) : IOException<br>[js, native]<br>actual class [ProtocolException](-protocol-exception/index.md)(host: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) : IOException<br>[jvm]<br>actual typealias [ProtocolException](-protocol-exception/index.md) = [java.net.ProtocolException](https://docs.oracle.com/javase/8/docs/api/java/net/ProtocolException.html) |
| [RuntimeMessageAdapter](-runtime-message-adapter/index.md) | [common]<br>class [RuntimeMessageAdapter](-runtime-message-adapter/index.md)&lt;[M](-runtime-message-adapter/index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), [B](-runtime-message-adapter/index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;(binding: [MessageBinding](-message-binding/index.md)&lt;[M](-runtime-message-adapter/index.md), [B](-runtime-message-adapter/index.md)&gt;) : [ProtoAdapter](../com.squareup.wire/-proto-adapter/index.md)&lt;[M](-runtime-message-adapter/index.md)&gt; |
| [Serializable](-serializable/index.md) | [common, js, native, jvm]<br>[common]<br>expect interface [Serializable](-serializable/index.md)<br>[js, native]<br>actual interface [Serializable](-serializable/index.md)<br>[jvm]<br>actual typealias [Serializable](-serializable/index.md) = [java.io.Serializable](https://docs.oracle.com/javase/8/docs/api/java/io/Serializable.html) |
| [Throws](-throws/index.md) | [common, jvm]<br>[common]<br>expect annotation class [Throws](-throws/index.md)(val exceptionClasses: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;out [Throwable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html)&gt;)<br>[jvm]<br>actual typealias [Throws](-throws/index.md) = [kotlin.jvm.Throws](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-throws/index.html) |

## Properties

| Name | Summary |
|---|---|
| [identityOrNull](identity-or-null.md) | [jvm]<br>val &lt;[E](identity-or-null.md) : [WireEnum](../com.squareup.wire/-wire-enum/index.md)&gt; [Class](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)&lt;[E](identity-or-null.md)&gt;.[identityOrNull](identity-or-null.md): [E](identity-or-null.md)?<br>The enum with constant 0. This is non-null for proto3 enum types. |

## Functions

| Name | Summary |
|---|---|
| [boxedOneOfClassName](boxed-one-of-class-name.md) | [common]<br>fun [boxedOneOfClassName](boxed-one-of-class-name.md)(oneOfName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [boxedOneOfKeyFieldName](boxed-one-of-key-field-name.md) | [common]<br>fun [boxedOneOfKeyFieldName](boxed-one-of-key-field-name.md)(oneOfName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), fieldName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Maps [oneOfName](boxed-one-of-key-field-name.md) and [fieldName](boxed-one-of-key-field-name.md) to the companion object key representing a boxed oneof field. |
| [boxedOneOfKeysFieldName](boxed-one-of-keys-field-name.md) | [common]<br>fun [boxedOneOfKeysFieldName](boxed-one-of-keys-field-name.md)(oneOfName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Maps [oneOfName](boxed-one-of-keys-field-name.md) to the companion object field of type `Set` containing the eligible keys. |
| [camelCase](camel-case.md) | [common]<br>expect fun [camelCase](camel-case.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), upperCamel: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Convert [string](camel-case.md), from snake case to camel case.<br>[js, jvm, native]<br>[js, jvm, native]<br>actual fun [camelCase](camel-case.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), upperCamel: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [checkElementsNotNull](check-elements-not-null.md) | [common]<br>fun [checkElementsNotNull](check-elements-not-null.md)(list: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;*&gt;)<br>Throw [NullPointerException](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-null-pointer-exception/index.html) if any of `list`'s items is null.<br>[common]<br>fun [checkElementsNotNull](check-elements-not-null.md)(map: [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)&lt;*, *&gt;)<br>Throw [NullPointerException](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-null-pointer-exception/index.html) if any of`map`'s keys or values is null. |
| [copyOf](copy-of.md) | [common]<br>fun &lt;[T](copy-of.md)&gt; [copyOf](copy-of.md)(list: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[T](copy-of.md)&gt;): [MutableList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)&lt;[T](copy-of.md)&gt;<br>fun &lt;[K](copy-of.md), [V](copy-of.md)&gt; [copyOf](copy-of.md)(map: [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)&lt;[K](copy-of.md), [V](copy-of.md)&gt;): [MutableMap](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-map/index.html)&lt;[K](copy-of.md), [V](copy-of.md)&gt;<br>fun &lt;[T](copy-of.md)&gt; [~~copyOf~~](copy-of.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), list: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[T](copy-of.md)&gt;?): [MutableList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)&lt;[T](copy-of.md)&gt;<br>fun &lt;[K](copy-of.md), [V](copy-of.md)&gt; [~~copyOf~~](copy-of.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), map: [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)&lt;[K](copy-of.md), [V](copy-of.md)&gt;?): [MutableMap](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-map/index.html)&lt;[K](copy-of.md), [V](copy-of.md)&gt; |
| [countNonNull](count-non-null.md) | [common]<br>fun [countNonNull](count-non-null.md)(a: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, b: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Returns the number of non-null values in `a, b`.<br>[common]<br>fun [countNonNull](count-non-null.md)(a: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, b: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, c: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Returns the number of non-null values in `a, b, c`.<br>[common]<br>fun [countNonNull](count-non-null.md)(a: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, b: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, c: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, d: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, vararg rest: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Returns the number of non-null values in `a, b, c, d, rest`. |
| [createRuntimeMessageAdapter](create-runtime-message-adapter.md) | [jvm]<br>fun &lt;[M](create-runtime-message-adapter.md) : [Message](../com.squareup.wire/-message/index.md)&lt;[M](create-runtime-message-adapter.md), [B](create-runtime-message-adapter.md)&gt;, [B](create-runtime-message-adapter.md) : [Message.Builder](../com.squareup.wire/-message/-builder/index.md)&lt;[M](create-runtime-message-adapter.md), [B](create-runtime-message-adapter.md)&gt;&gt; [createRuntimeMessageAdapter](create-runtime-message-adapter.md)(messageType: [Class](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)&lt;[M](create-runtime-message-adapter.md)&gt;, writeIdentityValues: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), classLoader: [ClassLoader](https://docs.oracle.com/javase/8/docs/api/java/lang/ClassLoader.html)? = messageType.classLoader): [RuntimeMessageAdapter](-runtime-message-adapter/index.md)&lt;[M](create-runtime-message-adapter.md), [B](create-runtime-message-adapter.md)&gt;<br>fun &lt;[M](create-runtime-message-adapter.md) : [Message](../com.squareup.wire/-message/index.md)&lt;[M](create-runtime-message-adapter.md), [B](create-runtime-message-adapter.md)&gt;, [B](create-runtime-message-adapter.md) : [Message.Builder](../com.squareup.wire/-message/-builder/index.md)&lt;[M](create-runtime-message-adapter.md), [B](create-runtime-message-adapter.md)&gt;&gt; [createRuntimeMessageAdapter](create-runtime-message-adapter.md)(messageType: [Class](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)&lt;[M](create-runtime-message-adapter.md)&gt;, typeUrl: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, syntax: [Syntax](../com.squareup.wire/-syntax/index.md), classLoader: [ClassLoader](https://docs.oracle.com/javase/8/docs/api/java/lang/ClassLoader.html)? = messageType.classLoader, writeIdentityValues: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false): [RuntimeMessageAdapter](-runtime-message-adapter/index.md)&lt;[M](create-runtime-message-adapter.md), [B](create-runtime-message-adapter.md)&gt; |
| [decodePrimitive_double](decode-primitive_double.md) | [common]<br>fun [decodePrimitive_double](decode-primitive_double.md)(reader: [ProtoReader](../com.squareup.wire/-proto-reader/index.md)): [Double](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html) |
| [decodePrimitive_fixed32](decode-primitive_fixed32.md) | [common]<br>fun [decodePrimitive_fixed32](decode-primitive_fixed32.md)(reader: [ProtoReader](../com.squareup.wire/-proto-reader/index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [decodePrimitive_fixed64](decode-primitive_fixed64.md) | [common]<br>fun [decodePrimitive_fixed64](decode-primitive_fixed64.md)(reader: [ProtoReader](../com.squareup.wire/-proto-reader/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [decodePrimitive_float](decode-primitive_float.md) | [common]<br>fun [decodePrimitive_float](decode-primitive_float.md)(reader: [ProtoReader](../com.squareup.wire/-proto-reader/index.md)): [Float](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float/index.html) |
| [decodePrimitive_int32](decode-primitive_int32.md) | [common]<br>fun [decodePrimitive_int32](decode-primitive_int32.md)(reader: [ProtoReader](../com.squareup.wire/-proto-reader/index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [decodePrimitive_int64](decode-primitive_int64.md) | [common]<br>fun [decodePrimitive_int64](decode-primitive_int64.md)(reader: [ProtoReader](../com.squareup.wire/-proto-reader/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [decodePrimitive_sfixed32](decode-primitive_sfixed32.md) | [common]<br>fun [decodePrimitive_sfixed32](decode-primitive_sfixed32.md)(reader: [ProtoReader](../com.squareup.wire/-proto-reader/index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [decodePrimitive_sfixed64](decode-primitive_sfixed64.md) | [common]<br>fun [decodePrimitive_sfixed64](decode-primitive_sfixed64.md)(reader: [ProtoReader](../com.squareup.wire/-proto-reader/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [decodePrimitive_sint32](decode-primitive_sint32.md) | [common]<br>fun [decodePrimitive_sint32](decode-primitive_sint32.md)(reader: [ProtoReader](../com.squareup.wire/-proto-reader/index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [decodePrimitive_sint64](decode-primitive_sint64.md) | [common]<br>fun [decodePrimitive_sint64](decode-primitive_sint64.md)(reader: [ProtoReader](../com.squareup.wire/-proto-reader/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [decodePrimitive_uint32](decode-primitive_uint32.md) | [common]<br>fun [decodePrimitive_uint32](decode-primitive_uint32.md)(reader: [ProtoReader](../com.squareup.wire/-proto-reader/index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [decodePrimitive_uint64](decode-primitive_uint64.md) | [common]<br>fun [decodePrimitive_uint64](decode-primitive_uint64.md)(reader: [ProtoReader](../com.squareup.wire/-proto-reader/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [encodeArray_double](encode-array_double.md) | [common]<br>fun [encodeArray_double](encode-array_double.md)(array: [DoubleArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double-array/index.html), writer: [ReverseProtoWriter](../com.squareup.wire/-reverse-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)) |
| [encodeArray_fixed32](encode-array_fixed32.md) | [common]<br>fun [encodeArray_fixed32](encode-array_fixed32.md)(array: [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html), writer: [ReverseProtoWriter](../com.squareup.wire/-reverse-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)) |
| [encodeArray_fixed64](encode-array_fixed64.md) | [common]<br>fun [encodeArray_fixed64](encode-array_fixed64.md)(array: [LongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long-array/index.html), writer: [ReverseProtoWriter](../com.squareup.wire/-reverse-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)) |
| [encodeArray_float](encode-array_float.md) | [common]<br>fun [encodeArray_float](encode-array_float.md)(array: [FloatArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float-array/index.html), writer: [ReverseProtoWriter](../com.squareup.wire/-reverse-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)) |
| [encodeArray_int32](encode-array_int32.md) | [common]<br>fun [encodeArray_int32](encode-array_int32.md)(array: [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html), writer: [ReverseProtoWriter](../com.squareup.wire/-reverse-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)) |
| [encodeArray_int64](encode-array_int64.md) | [common]<br>fun [encodeArray_int64](encode-array_int64.md)(array: [LongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long-array/index.html), writer: [ReverseProtoWriter](../com.squareup.wire/-reverse-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)) |
| [encodeArray_sfixed32](encode-array_sfixed32.md) | [common]<br>fun [encodeArray_sfixed32](encode-array_sfixed32.md)(array: [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html), writer: [ReverseProtoWriter](../com.squareup.wire/-reverse-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)) |
| [encodeArray_sfixed64](encode-array_sfixed64.md) | [common]<br>fun [encodeArray_sfixed64](encode-array_sfixed64.md)(array: [LongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long-array/index.html), writer: [ReverseProtoWriter](../com.squareup.wire/-reverse-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)) |
| [encodeArray_sint32](encode-array_sint32.md) | [common]<br>fun [encodeArray_sint32](encode-array_sint32.md)(array: [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html), writer: [ReverseProtoWriter](../com.squareup.wire/-reverse-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)) |
| [encodeArray_sint64](encode-array_sint64.md) | [common]<br>fun [encodeArray_sint64](encode-array_sint64.md)(array: [LongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long-array/index.html), writer: [ReverseProtoWriter](../com.squareup.wire/-reverse-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)) |
| [encodeArray_uint32](encode-array_uint32.md) | [common]<br>fun [encodeArray_uint32](encode-array_uint32.md)(array: [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html), writer: [ReverseProtoWriter](../com.squareup.wire/-reverse-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)) |
| [encodeArray_uint64](encode-array_uint64.md) | [common]<br>fun [encodeArray_uint64](encode-array_uint64.md)(array: [LongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long-array/index.html), writer: [ReverseProtoWriter](../com.squareup.wire/-reverse-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)) |
| [equals](equals.md) | [common]<br>fun [equals](equals.md)(a: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, b: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [immutableCopyOf](immutable-copy-of.md) | [common]<br>fun &lt;[T](immutable-copy-of.md)&gt; [immutableCopyOf](immutable-copy-of.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), list: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[T](immutable-copy-of.md)&gt;): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[T](immutable-copy-of.md)&gt;<br>fun &lt;[K](immutable-copy-of.md), [V](immutable-copy-of.md)&gt; [immutableCopyOf](immutable-copy-of.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), map: [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)&lt;[K](immutable-copy-of.md), [V](immutable-copy-of.md)&gt;): [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)&lt;[K](immutable-copy-of.md), [V](immutable-copy-of.md)&gt; |
| [immutableCopyOfMapWithStructValues](immutable-copy-of-map-with-struct-values.md) | [common]<br>fun &lt;[K](immutable-copy-of-map-with-struct-values.md), [V](immutable-copy-of-map-with-struct-values.md)&gt; [immutableCopyOfMapWithStructValues](immutable-copy-of-map-with-struct-values.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), map: [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)&lt;[K](immutable-copy-of-map-with-struct-values.md), [V](immutable-copy-of-map-with-struct-values.md)&gt;): [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)&lt;[K](immutable-copy-of-map-with-struct-values.md), [V](immutable-copy-of-map-with-struct-values.md)&gt;<br>Confirms the values of [map](immutable-copy-of-map-with-struct-values.md) are structs and returns an immutable copy. |
| [immutableCopyOfStruct](immutable-copy-of-struct.md) | [common]<br>fun &lt;[T](immutable-copy-of-struct.md)&gt; [immutableCopyOfStruct](immutable-copy-of-struct.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), value: [T](immutable-copy-of-struct.md)): [T](immutable-copy-of-struct.md)<br>Confirms [value](immutable-copy-of-struct.md) is a struct and returns an immutable copy. |
| [missingRequiredFields](missing-required-fields.md) | [common]<br>fun [missingRequiredFields](missing-required-fields.md)(vararg args: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [IllegalStateException](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-illegal-state-exception/index.html)<br>Create an exception for missing required fields. |
| [newMutableList](new-mutable-list.md) | [common]<br>fun &lt;[T](new-mutable-list.md)&gt; [newMutableList](new-mutable-list.md)(): [MutableList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)&lt;[T](new-mutable-list.md)&gt; |
| [newMutableMap](new-mutable-map.md) | [common]<br>fun &lt;[K](new-mutable-map.md), [V](new-mutable-map.md)&gt; [newMutableMap](new-mutable-map.md)(): [MutableMap](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-map/index.html)&lt;[K](new-mutable-map.md), [V](new-mutable-map.md)&gt; |
| [redactElements](redact-elements.md) | [jvm]<br>fun &lt;[T](redact-elements.md)&gt; [redactElements](redact-elements.md)(list: [MutableList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)&lt;[T](redact-elements.md)&gt;, adapter: [ProtoAdapter](../com.squareup.wire/-proto-adapter/index.md)&lt;[T](redact-elements.md)&gt;)<br>fun &lt;[T](redact-elements.md)&gt; [redactElements](redact-elements.md)(map: [MutableMap](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-map/index.html)&lt;*, [T](redact-elements.md)&gt;, adapter: [ProtoAdapter](../com.squareup.wire/-proto-adapter/index.md)&lt;[T](redact-elements.md)&gt;) |
| [redactElements](redact-elements.md) | [common]<br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;-redactElements&quot;)<br>fun &lt;[T](redact-elements.md)&gt; [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[T](redact-elements.md)&gt;.[redactElements](redact-elements.md)(adapter: [ProtoAdapter](../com.squareup.wire/-proto-adapter/index.md)&lt;[T](redact-elements.md)&gt;): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[T](redact-elements.md)&gt;<br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;-redactElements&quot;)<br>fun &lt;[K](redact-elements.md), [V](redact-elements.md)&gt; [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)&lt;[K](redact-elements.md), [V](redact-elements.md)&gt;.[redactElements](redact-elements.md)(adapter: [ProtoAdapter](../com.squareup.wire/-proto-adapter/index.md)&lt;[V](redact-elements.md)&gt;): [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)&lt;[K](redact-elements.md), [V](redact-elements.md)&gt; |
| [sanitize](sanitize.md) | [common]<br>fun [sanitize](sanitize.md)(value: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>fun [sanitize](sanitize.md)(values: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Return a string where `,[]{}\` are escaped with a `\`. |
| [toUnmodifiableList](to-unmodifiable-list.md) | [common, js, jvm, native]<br>[common]<br>expect fun &lt;[T](to-unmodifiable-list.md)&gt; [MutableList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)&lt;[T](to-unmodifiable-list.md)&gt;.[toUnmodifiableList](to-unmodifiable-list.md)(): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[T](to-unmodifiable-list.md)&gt;<br>[js, jvm, native]<br>actual inline fun &lt;[T](to-unmodifiable-list.md)&gt; [MutableList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)&lt;[T](to-unmodifiable-list.md)&gt;.[toUnmodifiableList](to-unmodifiable-list.md)(): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[T](to-unmodifiable-list.md)&gt; |
| [toUnmodifiableMap](to-unmodifiable-map.md) | [common, js, jvm, native]<br>[common]<br>expect fun &lt;[K](to-unmodifiable-map.md), [V](to-unmodifiable-map.md)&gt; [MutableMap](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-map/index.html)&lt;[K](to-unmodifiable-map.md), [V](to-unmodifiable-map.md)&gt;.[toUnmodifiableMap](to-unmodifiable-map.md)(): [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)&lt;[K](to-unmodifiable-map.md), [V](to-unmodifiable-map.md)&gt;<br>[js, jvm, native]<br>actual inline fun &lt;[K](to-unmodifiable-map.md), [V](to-unmodifiable-map.md)&gt; [MutableMap](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-map/index.html)&lt;[K](to-unmodifiable-map.md), [V](to-unmodifiable-map.md)&gt;.[toUnmodifiableMap](to-unmodifiable-map.md)(): [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)&lt;[K](to-unmodifiable-map.md), [V](to-unmodifiable-map.md)&gt; |
