//[wire-runtime](../../../index.md)/[com.squareup.wire](../index.md)/[EnumAdapter](index.md)

# EnumAdapter

expect abstract class [EnumAdapter](index.md)&lt;[E](index.md) : [WireEnum](../-wire-enum/index.md)[E](index.md) : [WireEnum](../-wire-enum/index.md)[E](index.md) : [WireEnum](../-wire-enum/index.md)[E](index.md) : [WireEnum](../-wire-enum/index.md)&gt; : [ProtoAdapter](../-proto-adapter/index.md)&lt;[E](index.md)&gt; actual abstract class [EnumAdapter](index.md)&lt;[E](index.md) : [WireEnum](../-wire-enum/index.md)[E](index.md) : [WireEnum](../-wire-enum/index.md)[E](index.md) : [WireEnum](../-wire-enum/index.md)[E](index.md) : [WireEnum](../-wire-enum/index.md)&gt; : [ProtoAdapter](../-proto-adapter/index.md)&lt;[E](index.md)&gt; actual abstract class [EnumAdapter](index.md)&lt;[E](index.md) : [WireEnum](../-wire-enum/index.md)[E](index.md) : [WireEnum](../-wire-enum/index.md)[E](index.md) : [WireEnum](../-wire-enum/index.md)[E](index.md) : [WireEnum](../-wire-enum/index.md)&gt; : [ProtoAdapter](../-proto-adapter/index.md)&lt;[E](index.md)&gt; actual abstract class [EnumAdapter](index.md)&lt;[E](index.md) : [WireEnum](../-wire-enum/index.md)[E](index.md) : [WireEnum](../-wire-enum/index.md)[E](index.md) : [WireEnum](../-wire-enum/index.md)[E](index.md) : [WireEnum](../-wire-enum/index.md)&gt; : [ProtoAdapter](../-proto-adapter/index.md)&lt;[E](index.md)&gt; 

An abstract [ProtoAdapter](../-proto-adapter/index.md) that converts values of an enum to and from integers.

An abstract [ProtoAdapter](../-proto-adapter/index.md) that converts values of an enum to and from integers.

An abstract [ProtoAdapter](../-proto-adapter/index.md) that converts values of an enum to and from integers.

An abstract [ProtoAdapter](../-proto-adapter/index.md) that converts values of an enum to and from integers.

#### Inheritors

| |
|---|
| [RuntimeEnumAdapter](../-runtime-enum-adapter/index.md) |

## Constructors

| | |
|---|---|
| [EnumAdapter](-enum-adapter.md) | [jvm]<br>constructor(type: [Class](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)&lt;[E](index.md)&gt;, syntax: [Syntax](../-syntax/index.md), identity: [E](index.md)?)constructor(type: [Class](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)&lt;[E](index.md)&gt;)constructor(type: [Class](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)&lt;[E](index.md)&gt;, syntax: [Syntax](../-syntax/index.md))constructor(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;[E](index.md)&gt;)constructor(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;[E](index.md)&gt;, syntax: [Syntax](../-syntax/index.md)) |

## Properties

| Name | Summary |
|---|---|
| [identity](../-proto-adapter/identity.md) | [common]<br>expect val [identity](../-proto-adapter/identity.md): [E](index.md)?<br>A special value that is used when a field is absent from an encoded proto3 message. When encoding a proto3 message, fields that hold this value will be omitted.<br>[js, jvm, native]<br>[js, jvm, native]<br>actual val [identity](../-proto-adapter/identity.md): [E](index.md)? |
| [sourceFile](../-proto-adapter/source-file.md) | [common]<br>expect val [sourceFile](../-proto-adapter/source-file.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?<br>Path to the file containing the protobuf definition of this type.<br>[js, jvm, native]<br>[js, jvm, native]<br>actual val [sourceFile](../-proto-adapter/source-file.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |
| [syntax](../-proto-adapter/syntax.md) | [common]<br>expect val [syntax](../-proto-adapter/syntax.md): [Syntax](../-syntax/index.md)<br>Identifies the syntax in which [type](../-proto-adapter/type.md) is defined in the proto schema. This string contains either &quot;proto2&quot; or &quot;proto3&quot;.<br>[js, jvm, native]<br>[js, jvm, native]<br>actual val [syntax](../-proto-adapter/syntax.md): [Syntax](../-syntax/index.md) |
| [type](../-proto-adapter/type.md) | [common, js, jvm, native]<br>[common]<br>expect val [type](../-proto-adapter/type.md): [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;?<br>[js, jvm, native]<br>actual val [type](../-proto-adapter/type.md): [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;? |
| [typeUrl](../-proto-adapter/type-url.md) | [common]<br>expect val [typeUrl](../-proto-adapter/type-url.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?<br>Identifies this type for inclusion in a `google.protobuf.Any`. This is a string like &quot;type.googleapis.com/packagename.messagename&quot; or null if this type is either not a message (such as scalars and enums), or was code-generated before Wire 3.2 which introduced support for type URLS.<br>[js, jvm, native]<br>[js, jvm, native]<br>actual val [typeUrl](../-proto-adapter/type-url.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |

## Functions

| Name | Summary |
|---|---|
| [asPacked](../-proto-adapter/as-packed.md) | [common, js, native]<br>[common]<br>expect fun [asPacked](../-proto-adapter/as-packed.md)(): [ProtoAdapter](../-proto-adapter/index.md)&lt;[List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[E](index.md)&gt;&gt;<br>[js, native]<br>actual fun [asPacked](../-proto-adapter/as-packed.md)(): [ProtoAdapter](../-proto-adapter/index.md)&lt;[List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[E](index.md)&gt;&gt;<br>Returns an adapter for `E` but as a packed, repeated value.<br>[jvm]<br>actual fun [asPacked](../-proto-adapter/as-packed.md)(): [ProtoAdapter](../-proto-adapter/index.md)&lt;[List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[E](index.md)&gt;&gt; |
| [asRepeated](../-proto-adapter/as-repeated.md) | [common, js, native]<br>[common]<br>expect fun [asRepeated](../-proto-adapter/as-repeated.md)(): [ProtoAdapter](../-proto-adapter/index.md)&lt;[List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[E](index.md)&gt;&gt;<br>[js, native]<br>actual fun [asRepeated](../-proto-adapter/as-repeated.md)(): [ProtoAdapter](../-proto-adapter/index.md)&lt;[List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[E](index.md)&gt;&gt;<br>Returns an adapter for `E` but as a repeated value.<br>[jvm]<br>actual fun [asRepeated](../-proto-adapter/as-repeated.md)(): [ProtoAdapter](../-proto-adapter/index.md)&lt;[List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[E](index.md)&gt;&gt; |
| [decode](decode.md) | [common, js, native]<br>[common]<br>expect open override fun [decode](decode.md)(reader: [ProtoReader](../-proto-reader/index.md)): [E](index.md)<br>[js, native]<br>actual open override fun [decode](decode.md)(reader: [ProtoReader](../-proto-reader/index.md)): [E](index.md)<br>Read a non-null value from `reader`.<br>[jvm]<br>actual open override fun [decode](decode.md)(reader: [ProtoReader](../-proto-reader/index.md)): [E](index.md)<br>fun [decode](../-proto-adapter/decode.md)(stream: [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html)): [E](index.md)<br>actual fun [decode](../-proto-adapter/decode.md)(bytes: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [E](index.md)<br>actual fun [decode](../-proto-adapter/decode.md)(source: BufferedSource): [E](index.md)<br>actual fun [decode](../-proto-adapter/decode.md)(bytes: ByteString): [E](index.md)<br>[common, js, native]<br>[common]<br>expect fun [decode](../-proto-adapter/decode.md)(bytes: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [E](index.md)<br>[js, native]<br>actual fun [decode](../-proto-adapter/decode.md)(bytes: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [E](index.md)<br>[common]<br>expect fun [decode](../-proto-adapter/decode.md)(bytes: ByteString): [E](index.md)<br>[js, native]<br>actual fun [decode](../-proto-adapter/decode.md)(bytes: ByteString): [E](index.md)<br>Read an encoded message from `bytes`.<br>[common, js, native]<br>[common]<br>expect fun [decode](../-proto-adapter/decode.md)(source: BufferedSource): [E](index.md)<br>[js, native]<br>actual fun [decode](../-proto-adapter/decode.md)(source: BufferedSource): [E](index.md)<br>Read an encoded message from `source`. |
| [decode](../decode.md) | [darwin]<br>@[ExperimentalUnsignedTypes](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-experimental-unsigned-types/index.html)<br>fun &lt;[E](../decode.md)&gt; [ProtoAdapter](../-proto-adapter/index.md)&lt;[E](../decode.md)&gt;.[decode](../decode.md)(data: NSData): [E](../decode.md)<br>Read an encoded message from `data`. |
| [encode](encode.md) | [common, js, native]<br>[common]<br>expect open override fun [encode](encode.md)(writer: [ProtoWriter](../-proto-writer/index.md), value: [E](index.md))<br>[js, native]<br>actual open override fun [encode](encode.md)(writer: [ProtoWriter](../-proto-writer/index.md), value: [E](index.md))<br>[common]<br>expect open override fun [encode](encode.md)(writer: [ReverseProtoWriter](../-reverse-proto-writer/index.md), value: [E](index.md))<br>[js, native]<br>actual open override fun [encode](encode.md)(writer: [ReverseProtoWriter](../-reverse-proto-writer/index.md), value: [E](index.md))<br>Write non-null `value` to `writer`.<br>[jvm]<br>actual open override fun [encode](encode.md)(writer: [ProtoWriter](../-proto-writer/index.md), value: [E](index.md))<br>actual open override fun [encode](encode.md)(writer: [ReverseProtoWriter](../-reverse-proto-writer/index.md), value: [E](index.md))<br>actual fun [encode](index.md#362516774%2FFunctions%2F1823866683)(value: [E](index.md)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>fun [encode](index.md#1817321442%2FFunctions%2F1823866683)(stream: [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html), value: [E](index.md))<br>actual fun [encode](index.md#-490803903%2FFunctions%2F1823866683)(sink: BufferedSink, value: [E](index.md))<br>[common, js, native]<br>[common]<br>expect fun [encode](index.md#362516774%2FFunctions%2F-1082500773)(value: [E](index.md)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>[js]<br>actual fun [encode](index.md#362516774%2FFunctions%2F-1733684867)(value: [E](index.md)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>[native]<br>actual fun [encode](index.md#362516774%2FFunctions%2F467161563)(value: [E](index.md)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>Encode `value` as a `byte[]`.<br>[common, js, native]<br>[common]<br>expect fun [encode](index.md#-490803903%2FFunctions%2F-1082500773)(sink: BufferedSink, value: [E](index.md))<br>[js]<br>actual fun [encode](index.md#-490803903%2FFunctions%2F-1733684867)(sink: BufferedSink, value: [E](index.md))<br>[native]<br>actual fun [encode](index.md#-490803903%2FFunctions%2F467161563)(sink: BufferedSink, value: [E](index.md))<br>Encode `value` and write it to `stream`. |
| encodeByteString | [common, js, native]<br>[common]<br>expect fun [encodeByteString](index.md#-320012307%2FFunctions%2F-1082500773)(value: [E](index.md)): ByteString<br>[js]<br>actual fun [encodeByteString](index.md#-320012307%2FFunctions%2F-1733684867)(value: [E](index.md)): ByteString<br>[native]<br>actual fun [encodeByteString](index.md#-320012307%2FFunctions%2F467161563)(value: [E](index.md)): ByteString<br>Encode `value` as a ByteString.<br>[jvm]<br>actual fun [encodeByteString](index.md#-320012307%2FFunctions%2F1823866683)(value: [E](index.md)): ByteString |
| [encodedSize](encoded-size.md) | [common, js, native]<br>[common]<br>expect open override fun [encodedSize](encoded-size.md)(value: [E](index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[js, native]<br>actual open override fun [encodedSize](encoded-size.md)(value: [E](index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>The size of the non-null data `value`. This does not include the size required for a length-delimited prefix (should the type require one).<br>[jvm]<br>actual open override fun [encodedSize](encoded-size.md)(value: [E](index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| encodedSizeWithTag | [common, js, native]<br>[common]<br>expect open fun [encodedSizeWithTag](index.md#804415853%2FFunctions%2F-1082500773)(tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[js]<br>actual open fun [encodedSizeWithTag](index.md#804415853%2FFunctions%2F-1733684867)(tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[native]<br>actual open fun [encodedSizeWithTag](index.md#804415853%2FFunctions%2F467161563)(tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>The size of `tag` and `value` in the wire format. This size includes the tag, type, length-delimited prefix (should the type require one), and value. Returns 0 if `value` is null.<br>[jvm]<br>actual open fun [encodedSizeWithTag](index.md#804415853%2FFunctions%2F1823866683)(tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| encodeWithTag | [common, js, native]<br>[common]<br>expect open fun [encodeWithTag](index.md#-1882930246%2FFunctions%2F-1082500773)(writer: [ProtoWriter](../-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?)<br>[js]<br>actual open fun [encodeWithTag](index.md#-1882930246%2FFunctions%2F-1733684867)(writer: [ProtoWriter](../-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?)<br>[native]<br>actual open fun [encodeWithTag](index.md#-1882930246%2FFunctions%2F467161563)(writer: [ProtoWriter](../-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?)<br>[common]<br>expect open fun [encodeWithTag](index.md#1543761198%2FFunctions%2F-1082500773)(writer: [ReverseProtoWriter](../-reverse-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?)<br>[js]<br>actual open fun [encodeWithTag](index.md#1543761198%2FFunctions%2F-1733684867)(writer: [ReverseProtoWriter](../-reverse-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?)<br>[native]<br>actual open fun [encodeWithTag](index.md#1543761198%2FFunctions%2F467161563)(writer: [ReverseProtoWriter](../-reverse-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?)<br>Write `tag` and `value` to `writer`. If value is null this does nothing.<br>[jvm]<br>actual open fun [encodeWithTag](index.md#-1882930246%2FFunctions%2F1823866683)(writer: [ProtoWriter](../-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?)<br>actual open fun [encodeWithTag](index.md#1543761198%2FFunctions%2F1823866683)(writer: [ReverseProtoWriter](../-reverse-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [E](index.md)?) |
| [redact](redact.md) | [common, js, native]<br>[common]<br>expect open override fun [redact](redact.md)(value: [E](index.md)): [E](index.md)<br>[js, native]<br>actual open override fun [redact](redact.md)(value: [E](index.md)): [E](index.md)<br>Returns the redacted form of `value`.<br>[jvm]<br>actual open override fun [redact](redact.md)(value: [E](index.md)): [E](index.md) |
| toString | [common, js, native]<br>[common]<br>expect open fun [toString](index.md#-2000452144%2FFunctions%2F-1082500773)(value: [E](index.md)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[js]<br>actual open fun [toString](index.md#-2000452144%2FFunctions%2F-1733684867)(value: [E](index.md)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[native]<br>actual open fun [toString](index.md#-2000452144%2FFunctions%2F467161563)(value: [E](index.md)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns a human-readable version of the given `value`.<br>[jvm]<br>actual open fun [toString](index.md#-2000452144%2FFunctions%2F1823866683)(value: [E](index.md)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| tryDecode | [common]<br>expect fun [tryDecode](index.md#-1386937699%2FFunctions%2F-1082500773)(reader: [ProtoReader](../-proto-reader/index.md), destination: [MutableList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)&lt;[E](index.md)&gt;)<br>Reads a value and appends it to [destination](index.md#-1386937699%2FFunctions%2F-1082500773) if this has data available. Otherwise, it will only clear the reader state.<br>[js, jvm, native]<br>[js]<br>actual fun [tryDecode](index.md#-1386937699%2FFunctions%2F-1733684867)(reader: [ProtoReader](../-proto-reader/index.md), destination: [MutableList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)&lt;[E](index.md)&gt;)<br>[jvm]<br>actual fun [tryDecode](index.md#-1386937699%2FFunctions%2F1823866683)(reader: [ProtoReader](../-proto-reader/index.md), destination: [MutableList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)&lt;[E](index.md)&gt;)<br>[native]<br>actual fun [tryDecode](index.md#-1386937699%2FFunctions%2F467161563)(reader: [ProtoReader](../-proto-reader/index.md), destination: [MutableList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)&lt;[E](index.md)&gt;) |
