/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.internal;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\t\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/squareup/wire/internal/LongArrayList;", "", "initialCapacity", "", "<init>", "(I)V", "data", "", "size", "toArray", "add", "", "long", "", "isNotEmpty", "", "ensureCapacity", "minCapacity", "toString", "", "Companion", "wire-runtime"})
public final class LongArrayList {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private long[] data;
    private int size;

    public LongArrayList(int initialCapacity) {
        this.data = new long[initialCapacity];
    }

    @NotNull
    public final long[] toArray() {
        if (this.size < this.data.length) {
            long[] lArray = Arrays.copyOf(this.data, this.size);
            Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(...)");
            this.data = lArray;
        }
        return this.data;
    }

    public final void add(long l) {
        this.ensureCapacity(this.size + 1);
        int n = this.size;
        this.size = n + 1;
        this.data[n] = l;
    }

    public final boolean isNotEmpty() {
        return this.size > 0;
    }

    private final void ensureCapacity(int minCapacity) {
        if (minCapacity > this.data.length) {
            long[] lArray = Arrays.copyOf(this.data, Math.max(this.data.length * 3 / 2 + 1, minCapacity));
            Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(...)");
            this.data = lArray;
        }
    }

    @NotNull
    public String toString() {
        long[] lArray = Arrays.copyOf(this.data, this.size);
        Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(...)");
        String string = Arrays.toString(lArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/squareup/wire/internal/LongArrayList$Companion;", "", "<init>", "()V", "forDecoding", "Lcom/squareup/wire/internal/LongArrayList;", "minLengthInBytes", "", "minimumElementByteSize", "", "wire-runtime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LongArrayList forDecoding(long minLengthInBytes, long minimumElementByteSize) {
            int minElements = (int)RangesKt.coerceAtMost((long)(minLengthInBytes / minimumElementByteSize), (long)Integer.MAX_VALUE);
            return new LongArrayList(minElements);
        }

        @NotNull
        public final LongArrayList forDecoding(int minLengthInBytes, int minimumElementByteSize) {
            int minElements = minLengthInBytes / minimumElementByteSize;
            return new LongArrayList(minElements);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

