/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.internal;

import com.squareup.wire.EnumAdapter;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.Syntax;
import com.squareup.wire.internal.DurationJsonFormatter;
import com.squareup.wire.internal.EnumJsonFormatter;
import com.squareup.wire.internal.FieldOrOneOfBinding;
import com.squareup.wire.internal.InstantJsonFormatter;
import com.squareup.wire.internal.JsonFormatter;
import com.squareup.wire.internal.RuntimeMessageAdapter;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\b()*+,-./B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\u0006\u001a\u00028\u00012\u0006\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH&\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00028\u00012\u0006\u0010\f\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\rJ)\u0010\u000e\u001a\u00028\u00012\u0006\u0010\u0007\u001a\u00028\u00002\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u00028\u00012\u0006\u0010\u0007\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\rJ\u0019\u0010\u0014\u001a\u00028\u00012\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0010H&\u00a2\u0006\u0002\u0010\u0016JA\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u0018\"\b\b\u0002\u0010\u0019*\u00020\u0003\"\b\b\u0003\u0010\u001a*\u00020\u00032\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u0002H\u001a0\u001c2\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001dJE\u0010\u001e\u001a\u00028\u0001\"\b\b\u0002\u0010\u0019*\u00020\u0003\"\b\b\u0003\u0010\u001a*\u00020\u00032\u0006\u0010\u0007\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u0002H\u001a0\"H\u0002\u00a2\u0006\u0002\u0010#J\"\u0010$\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00102\u0006\u0010\u001f\u001a\u00020 2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030&H\u0002J\u0018\u0010'\u001a\u0006\u0012\u0002\b\u00030\u00102\n\u0010%\u001a\u0006\u0012\u0002\b\u00030&H\u0002\u00a8\u00060"}, d2={"Lcom/squareup/wire/internal/JsonIntegration;", "F", "A", "", "<init>", "()V", "frameworkAdapter", "framework", "type", "Ljava/lang/reflect/Type;", "(Ljava/lang/Object;Ljava/lang/reflect/Type;)Ljava/lang/Object;", "listAdapter", "elementAdapter", "(Ljava/lang/Object;)Ljava/lang/Object;", "mapAdapter", "keyFormatter", "Lcom/squareup/wire/internal/JsonFormatter;", "valueAdapter", "(Ljava/lang/Object;Lcom/squareup/wire/internal/JsonFormatter;Ljava/lang/Object;)Ljava/lang/Object;", "structAdapter", "formatterAdapter", "jsonStringAdapter", "(Lcom/squareup/wire/internal/JsonFormatter;)Ljava/lang/Object;", "jsonAdapters", "", "M", "B", "adapter", "Lcom/squareup/wire/internal/RuntimeMessageAdapter;", "(Lcom/squareup/wire/internal/RuntimeMessageAdapter;Ljava/lang/Object;)Ljava/util/List;", "jsonAdapter", "syntax", "Lcom/squareup/wire/Syntax;", "field", "Lcom/squareup/wire/internal/FieldOrOneOfBinding;", "(Ljava/lang/Object;Lcom/squareup/wire/Syntax;Lcom/squareup/wire/internal/FieldOrOneOfBinding;)Ljava/lang/Object;", "jsonFormatter", "protoAdapter", "Lcom/squareup/wire/ProtoAdapter;", "mapKeyJsonFormatter", "UnsignedLongAsNumberJsonFormatter", "UnsignedLongAsStringJsonFormatter", "LongAsStringJsonFormatter", "UnsignedIntAsNumberJsonFormatter", "UnsignedIntAsStringJsonFormatter", "IntAsStringJsonFormatter", "ByteStringJsonFormatter", "StringJsonFormatter", "wire-runtime"})
@SourceDebugExtension(value={"SMAP\nJsonIntegration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonIntegration.kt\ncom/squareup/wire/internal/JsonIntegration\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,248:1\n37#2,2:249\n11165#3:251\n11500#3,3:252\n*S KotlinDebug\n*F\n+ 1 JsonIntegration.kt\ncom/squareup/wire/internal/JsonIntegration\n*L\n59#1:249,2\n60#1:251\n60#1:252,3\n*E\n"})
public abstract class JsonIntegration<F, A> {
    public abstract A frameworkAdapter(F var1, @NotNull Type var2);

    public abstract A listAdapter(A var1);

    public abstract A mapAdapter(F var1, @NotNull JsonFormatter<?> var2, A var3);

    public abstract A structAdapter(F var1);

    public abstract A formatterAdapter(@NotNull JsonFormatter<?> var1);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <M, B> List<A> jsonAdapters(@NotNull RuntimeMessageAdapter<M, B> adapter, F framework) {
        void $this$mapTo$iv$iv;
        FieldOrOneOfBinding[] fieldBindings;
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        FieldOrOneOfBinding[] $this$toTypedArray$iv = adapter.getFields().values();
        boolean $i$f$toTypedArray = false;
        FieldOrOneOfBinding[] thisCollection$iv = $this$toTypedArray$iv;
        FieldOrOneOfBinding[] $this$map$iv = fieldBindings = thisCollection$iv.toArray(new FieldOrOneOfBinding[0]);
        boolean $i$f$map = false;
        thisCollection$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_12 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.jsonAdapter(framework, adapter.getSyntax(), (FieldOrOneOfBinding<M, B>)it));
        }
        return (List)destination$iv$iv;
    }

    private final <M, B> A jsonAdapter(F framework, Syntax syntax, FieldOrOneOfBinding<M, B> field) {
        A a;
        if (field.getSingleAdapter().isStruct$wire_runtime()) {
            return this.structAdapter(framework);
        }
        JsonFormatter<?> jsonStringAdapter = this.jsonFormatter(syntax, field.getSingleAdapter());
        JsonFormatter<?> jsonFormatter = jsonStringAdapter;
        if (jsonFormatter != null) {
            a = this.formatterAdapter(jsonFormatter);
        } else {
            KClass<?> kClass = field.getSingleAdapter().getType();
            Class clazz = kClass != null ? JvmClassMappingKt.getJavaObjectType(kClass) : null;
            Intrinsics.checkNotNull((Object)clazz, (String)"null cannot be cast to non-null type java.lang.reflect.Type");
            a = this.frameworkAdapter(framework, clazz);
        }
        A singleAdapter = a;
        return field.getLabel().isRepeated() ? this.listAdapter(singleAdapter) : (field.isMap() ? this.mapAdapter(framework, this.mapKeyJsonFormatter(field.getKeyAdapter()), singleAdapter) : singleAdapter);
    }

    private final JsonFormatter<?> jsonFormatter(Syntax syntax, ProtoAdapter<?> protoAdapter) {
        ProtoAdapter<?> protoAdapter2 = protoAdapter;
        if (Intrinsics.areEqual(protoAdapter2, ProtoAdapter.BYTES) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.BYTES_VALUE)) {
            return ByteStringJsonFormatter.INSTANCE;
        }
        if (Intrinsics.areEqual(protoAdapter2, ProtoAdapter.DURATION)) {
            return DurationJsonFormatter.INSTANCE;
        }
        if (Intrinsics.areEqual(protoAdapter2, ProtoAdapter.INSTANT)) {
            return InstantJsonFormatter.INSTANCE;
        }
        if (protoAdapter2 instanceof EnumAdapter) {
            return new EnumJsonFormatter((EnumAdapter)protoAdapter);
        }
        if (syntax == Syntax.PROTO_2) {
            protoAdapter2 = protoAdapter;
            return Intrinsics.areEqual(protoAdapter2, ProtoAdapter.UINT64) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.UINT64_VALUE) ? (JsonFormatter)UnsignedLongAsNumberJsonFormatter.INSTANCE : null;
        }
        protoAdapter2 = protoAdapter;
        return Intrinsics.areEqual(protoAdapter2, ProtoAdapter.UINT32) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.FIXED32) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.UINT32_VALUE) ? (JsonFormatter)UnsignedIntAsNumberJsonFormatter.INSTANCE : (Intrinsics.areEqual(protoAdapter2, ProtoAdapter.INT64) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.SFIXED64) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.SINT64) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.INT64_VALUE) ? (JsonFormatter)LongAsStringJsonFormatter.INSTANCE : (Intrinsics.areEqual(protoAdapter2, ProtoAdapter.FIXED64) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.UINT64) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.UINT64_VALUE) ? (JsonFormatter)UnsignedLongAsStringJsonFormatter.INSTANCE : null));
    }

    private final JsonFormatter<?> mapKeyJsonFormatter(ProtoAdapter<?> protoAdapter) {
        JsonFormatter jsonFormatter;
        ProtoAdapter<?> protoAdapter2 = protoAdapter;
        if (Intrinsics.areEqual(protoAdapter2, ProtoAdapter.STRING)) {
            jsonFormatter = StringJsonFormatter.INSTANCE;
        } else if (Intrinsics.areEqual(protoAdapter2, ProtoAdapter.INT32) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.SINT32) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.SFIXED32)) {
            jsonFormatter = IntAsStringJsonFormatter.INSTANCE;
        } else if (Intrinsics.areEqual(protoAdapter2, ProtoAdapter.FIXED32) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.UINT32)) {
            jsonFormatter = UnsignedIntAsStringJsonFormatter.INSTANCE;
        } else if (Intrinsics.areEqual(protoAdapter2, ProtoAdapter.INT64) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.SFIXED64) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.SINT64)) {
            jsonFormatter = LongAsStringJsonFormatter.INSTANCE;
        } else if (Intrinsics.areEqual(protoAdapter2, ProtoAdapter.FIXED64) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.UINT64)) {
            jsonFormatter = UnsignedLongAsStringJsonFormatter.INSTANCE;
        } else {
            throw new IllegalStateException(("Unexpected map key type: " + protoAdapter.getType()).toString());
        }
        return jsonFormatter;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/squareup/wire/internal/JsonIntegration$ByteStringJsonFormatter;", "Lcom/squareup/wire/internal/JsonFormatter;", "Lokio/ByteString;", "<init>", "()V", "toStringOrNumber", "", "value", "fromString", "wire-runtime"})
    private static final class ByteStringJsonFormatter
    implements JsonFormatter<ByteString> {
        @NotNull
        public static final ByteStringJsonFormatter INSTANCE = new ByteStringJsonFormatter();

        private ByteStringJsonFormatter() {
        }

        @NotNull
        public String toStringOrNumber(@NotNull ByteString value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value.base64();
        }

        @Override
        @Nullable
        public ByteString fromString(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return ByteString.Companion.decodeBase64(value);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lcom/squareup/wire/internal/JsonIntegration$IntAsStringJsonFormatter;", "Lcom/squareup/wire/internal/JsonFormatter;", "", "<init>", "()V", "fromString", "value", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "toStringOrNumber", "wire-runtime"})
    private static final class IntAsStringJsonFormatter
    implements JsonFormatter<Integer> {
        @NotNull
        public static final IntAsStringJsonFormatter INSTANCE = new IntAsStringJsonFormatter();

        private IntAsStringJsonFormatter() {
        }

        @Override
        @NotNull
        public Integer fromString(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Integer.parseInt(value);
        }

        @NotNull
        public String toStringOrNumber(int value) {
            return String.valueOf(value);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0015\u0010\b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/squareup/wire/internal/JsonIntegration$LongAsStringJsonFormatter;", "Lcom/squareup/wire/internal/JsonFormatter;", "", "<init>", "()V", "toStringOrNumber", "", "value", "fromString", "(Ljava/lang/String;)Ljava/lang/Long;", "wire-runtime"})
    private static final class LongAsStringJsonFormatter
    implements JsonFormatter<Long> {
        @NotNull
        public static final LongAsStringJsonFormatter INSTANCE = new LongAsStringJsonFormatter();

        private LongAsStringJsonFormatter() {
        }

        @NotNull
        public String toStringOrNumber(long value) {
            return String.valueOf(value);
        }

        @Override
        @NotNull
        public Long fromString(@NotNull String value) {
            long l;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            try {
                l = Long.parseLong(value);
            }
            catch (Exception e) {
                l = new BigDecimal(value).longValueExact();
            }
            return l;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lcom/squareup/wire/internal/JsonIntegration$StringJsonFormatter;", "Lcom/squareup/wire/internal/JsonFormatter;", "", "<init>", "()V", "toStringOrNumber", "value", "fromString", "wire-runtime"})
    private static final class StringJsonFormatter
    implements JsonFormatter<String> {
        @NotNull
        public static final StringJsonFormatter INSTANCE = new StringJsonFormatter();

        private StringJsonFormatter() {
        }

        @NotNull
        public String toStringOrNumber(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value;
        }

        @Override
        @NotNull
        public String fromString(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/squareup/wire/internal/JsonIntegration$UnsignedIntAsNumberJsonFormatter;", "Lcom/squareup/wire/internal/JsonFormatter;", "", "<init>", "()V", "power32", "", "maxInt", "fromString", "value", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "toStringOrNumber", "", "wire-runtime"})
    private static final class UnsignedIntAsNumberJsonFormatter
    implements JsonFormatter<Integer> {
        @NotNull
        public static final UnsignedIntAsNumberJsonFormatter INSTANCE = new UnsignedIntAsNumberJsonFormatter();
        private static final long power32 = 0x100000000L;
        private static final long maxInt = Integer.MAX_VALUE;

        private UnsignedIntAsNumberJsonFormatter() {
        }

        @Override
        @NotNull
        public Integer fromString(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            long longValue = (long)Double.parseDouble(value);
            return longValue >= Integer.MAX_VALUE ? (int)(longValue - 0x100000000L) : (int)longValue;
        }

        @Override
        @NotNull
        public Object toStringOrNumber(int value) {
            return value < 0 ? (Number)((long)value + 0x100000000L) : (Number)value;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/squareup/wire/internal/JsonIntegration$UnsignedIntAsStringJsonFormatter;", "Lcom/squareup/wire/internal/JsonFormatter;", "", "<init>", "()V", "power32", "", "fromString", "value", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "toStringOrNumber", "", "wire-runtime"})
    private static final class UnsignedIntAsStringJsonFormatter
    implements JsonFormatter<Integer> {
        @NotNull
        public static final UnsignedIntAsStringJsonFormatter INSTANCE = new UnsignedIntAsStringJsonFormatter();
        private static final long power32 = 0x100000000L;

        private UnsignedIntAsStringJsonFormatter() {
        }

        @Override
        @NotNull
        public Integer fromString(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return (int)Long.parseLong(value);
        }

        @Override
        @NotNull
        public Object toStringOrNumber(int value) {
            return value < 0 ? String.valueOf((long)value + 0x100000000L) : String.valueOf(value);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/squareup/wire/internal/JsonIntegration$UnsignedLongAsNumberJsonFormatter;", "Lcom/squareup/wire/internal/JsonFormatter;", "", "<init>", "()V", "power64", "Ljava/math/BigInteger;", "maxLong", "kotlin.jvm.PlatformType", "Ljava/math/BigInteger;", "fromString", "value", "", "(Ljava/lang/String;)Ljava/lang/Long;", "toStringOrNumber", "", "wire-runtime"})
    private static final class UnsignedLongAsNumberJsonFormatter
    implements JsonFormatter<Long> {
        @NotNull
        public static final UnsignedLongAsNumberJsonFormatter INSTANCE = new UnsignedLongAsNumberJsonFormatter();
        @NotNull
        private static final BigInteger power64 = new BigInteger("18446744073709551616");
        private static final BigInteger maxLong = BigInteger.valueOf(Long.MAX_VALUE);

        private UnsignedLongAsNumberJsonFormatter() {
        }

        @Override
        @NotNull
        public Long fromString(@NotNull String value) {
            BigInteger bigInteger;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            try {
                bigInteger = new BigInteger(value);
            }
            catch (Exception e) {
                bigInteger = new BigDecimal(value).toBigInteger();
            }
            BigInteger bigInteger2 = bigInteger;
            return bigInteger2.compareTo(maxLong) > 0 ? bigInteger2.subtract(power64).longValue() : bigInteger2.longValue();
        }

        @Override
        @NotNull
        public Object toStringOrNumber(long value) {
            return value < 0L ? power64.add(BigInteger.valueOf(value)) : Long.valueOf(value);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0015\u0010\b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/squareup/wire/internal/JsonIntegration$UnsignedLongAsStringJsonFormatter;", "Lcom/squareup/wire/internal/JsonFormatter;", "", "<init>", "()V", "toStringOrNumber", "", "value", "fromString", "(Ljava/lang/String;)Ljava/lang/Long;", "wire-runtime"})
    private static final class UnsignedLongAsStringJsonFormatter
    implements JsonFormatter<Long> {
        @NotNull
        public static final UnsignedLongAsStringJsonFormatter INSTANCE = new UnsignedLongAsStringJsonFormatter();

        private UnsignedLongAsStringJsonFormatter() {
        }

        @NotNull
        public String toStringOrNumber(long value) {
            return UnsignedLongAsNumberJsonFormatter.INSTANCE.toStringOrNumber(value).toString();
        }

        @Override
        @NotNull
        public Long fromString(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return UnsignedLongAsNumberJsonFormatter.INSTANCE.fromString(value);
        }
    }
}

