[wire-runtime](../../index.md) / [com.squareup.wire](../index.md) / [EnumAdapter](./index.md)

# EnumAdapter

`abstract expect class EnumAdapter<E : `[`WireEnum`](../-wire-enum/index.md)`> : `[`ProtoAdapter`](../-proto-adapter/index.md)`<`[`E`](index.md#E)`>`

**Platform and version requirements:** JVM, js, native

An abstract [ProtoAdapter](../-proto-adapter/index.md) that converts values of an enum to and from integers.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md)<br>(JVM) | `EnumAdapter(type: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`E`](index.md#E)`>)`<br>An abstract [ProtoAdapter](../-proto-adapter/index.md) that converts values of an enum to and from integers.`EnumAdapter(type: `[`Class`](http://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)`<`[`E`](index.md#E)`>)` |

### Inherited Properties

| Name | Summary |
|---|---|
| [type](../-proto-adapter/type.md)<br>(JVM, js, native) | `val type: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<*>?` |

### Functions

| Name | Summary |
|---|---|
| [decode](decode.md) | `open fun decode(reader: `[`ProtoReader`](../-proto-reader/index.md)`): `[`E`](index.md#E)<br>Read a non-null value from `reader`.`open actual fun decode(reader: <ERROR CLASS>): `[`E`](index.md#E) |
| [encode](encode.md) | `open fun encode(writer: `[`ProtoWriter`](../-proto-writer/index.md)`, value: `[`E`](index.md#E)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Write non-null `value` to `writer`.`open actual fun encode(writer: <ERROR CLASS>, value: `[`E`](index.md#E)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [encodedSize](encoded-size.md) | `open fun encodedSize(value: `[`E`](index.md#E)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>The size of the non-null data `value`. This does not include the size required for a length-delimited prefix (should the type require one). |
| [fromValue](from-value.md) | `abstract fun fromValue(value: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`E`](index.md#E)`?`<br>Converts an integer to an enum. Returns null if there is no corresponding enum. |
| [redact](redact.md) | `open fun redact(value: `[`E`](index.md#E)`): `[`E`](index.md#E)<br>Returns the redacted form of `value`. |

### Inherited Functions

| Name | Summary |
|---|---|
| [asPacked](../-proto-adapter/as-packed.md)<br>(JVM, js, native) | `fun asPacked(): `[`ProtoAdapter`](../-proto-adapter/index.md)`<`[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`E`](../-proto-adapter/index.md#E)`>>`<br>Returns an adapter for `E` but as a packed, repeated value. |
| [asRepeated](../-proto-adapter/as-repeated.md)<br>(JVM, js, native) | `fun asRepeated(): `[`ProtoAdapter`](../-proto-adapter/index.md)`<`[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`E`](../-proto-adapter/index.md#E)`>>`<br>Returns an adapter for `E` but as a repeated value. |
| [decode](../-proto-adapter/decode.md)<br>(JVM) | `fun decode(bytes: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`): `[`E`](../-proto-adapter/index.md#E)<br>Read an encoded message from `bytes`.`fun decode(source: <ERROR CLASS>): `[`E`](../-proto-adapter/index.md#E)<br>Read an encoded message from `source`.`fun decode(stream: `[`InputStream`](http://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html)`): `[`E`](../-proto-adapter/index.md#E) |
| [encode](../-proto-adapter/encode.md)<br>(JVM) | `fun encode(sink: <ERROR CLASS>, value: `[`E`](../-proto-adapter/index.md#E)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Encode `value` and write it to `stream`.`fun encode(value: `[`E`](../-proto-adapter/index.md#E)`): `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>Encode `value` as a `byte[]`.`fun encode(stream: `[`OutputStream`](http://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html)`, value: `[`E`](../-proto-adapter/index.md#E)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [encodeWithTag](../-proto-adapter/encode-with-tag.md) | `open fun encodeWithTag(writer: `[`ProtoWriter`](../-proto-writer/index.md)`, tag: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, value: `[`E`](../-proto-adapter/index.md#E)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Write `tag` and `value` to `writer`. If value is null this does nothing.`open actual fun encodeWithTag(writer: <ERROR CLASS>, tag: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, value: `[`E`](../-proto-adapter/index.md#E)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [encodedSizeWithTag](../-proto-adapter/encoded-size-with-tag.md)<br>(JVM, js, native) | `open fun encodedSizeWithTag(tag: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, value: `[`E`](../-proto-adapter/index.md#E)`?): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>The size of `tag` and `value` in the wire format. This size includes the tag, type, length-delimited prefix (should the type require one), and value. Returns 0 if `value` is null. |
| [toString](../-proto-adapter/to-string.md)<br>(JVM, js, native) | `open fun toString(value: `[`E`](../-proto-adapter/index.md#E)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns a human-readable version of the given `value`. |
