[wire-runtime](../../index.md) / [com.squareup.wire](../index.md) / [ProtoAdapter](./index.md)

# ProtoAdapter

`abstract expect class ProtoAdapter<E>`

**Platform and version requirements:** JVM, js, native

### Exceptions

| Name | Summary |
|---|---|
| [EnumConstantNotFoundException](-enum-constant-not-found-exception/index.md)<br>(JVM, js, native) | `class EnumConstantNotFoundException : `[`IllegalArgumentException`](http://docs.oracle.com/javase/8/docs/api/java/lang/IllegalArgumentException.html) |

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `ProtoAdapter(fieldEncoding: `[`FieldEncoding`](../-field-encoding/index.md)`, type: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<*>?)`<br>`ProtoAdapter(fieldEncoding: <ERROR CLASS>, type: `[`Class`](http://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)`<*>)`<br>`ProtoAdapter(actual fieldEncoding: <ERROR CLASS>, actual type: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<*>?)` |

### Properties

| Name | Summary |
|---|---|
| [type](type.md) | `val type: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<*>?` |

### Functions

| Name | Summary |
|---|---|
| [asPacked](as-packed.md) | `fun asPacked(): `[`ProtoAdapter`](./index.md)`<`[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`E`](index.md#E)`>>`<br>Returns an adapter for `E` but as a packed, repeated value. |
| [asRepeated](as-repeated.md) | `fun asRepeated(): `[`ProtoAdapter`](./index.md)`<`[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`E`](index.md#E)`>>`<br>Returns an adapter for `E` but as a repeated value. |
| [decode](decode.md) | `abstract fun decode(reader: `[`ProtoReader`](../-proto-reader/index.md)`): `[`E`](index.md#E)<br>Read a non-null value from `reader`.`fun decode(bytes: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`): `[`E`](index.md#E)<br>`fun decode(bytes: <ERROR CLASS>): `[`E`](index.md#E)<br>Read an encoded message from `bytes`.`fun decode(source: <ERROR CLASS>): `[`E`](index.md#E)<br>Read an encoded message from `source`.`fun decode(stream: `[`InputStream`](http://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html)`): `[`E`](index.md#E) |
| [encode](encode.md) | `abstract fun encode(writer: `[`ProtoWriter`](../-proto-writer/index.md)`, value: `[`E`](index.md#E)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Write non-null `value` to `writer`.`fun encode(sink: <ERROR CLASS>, value: `[`E`](index.md#E)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Encode `value` and write it to `stream`.`fun encode(value: `[`E`](index.md#E)`): `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>Encode `value` as a `byte[]`.`fun encode(stream: `[`OutputStream`](http://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html)`, value: `[`E`](index.md#E)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [encodeWithTag](encode-with-tag.md) | `open fun encodeWithTag(writer: `[`ProtoWriter`](../-proto-writer/index.md)`, tag: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, value: `[`E`](index.md#E)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Write `tag` and `value` to `writer`. If value is null this does nothing.`open actual fun encodeWithTag(writer: <ERROR CLASS>, tag: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, value: `[`E`](index.md#E)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [encodedSize](encoded-size.md) | `abstract fun encodedSize(value: `[`E`](index.md#E)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>The size of the non-null data `value`. This does not include the size required for a length-delimited prefix (should the type require one). |
| [encodedSizeWithTag](encoded-size-with-tag.md) | `open fun encodedSizeWithTag(tag: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, value: `[`E`](index.md#E)`?): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>The size of `tag` and `value` in the wire format. This size includes the tag, type, length-delimited prefix (should the type require one), and value. Returns 0 if `value` is null. |
| [redact](redact.md) | `abstract fun redact(value: `[`E`](index.md#E)`): `[`E`](index.md#E)<br>Returns the redacted form of `value`. |
| [toString](to-string.md) | `open fun toString(value: `[`E`](index.md#E)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns a human-readable version of the given `value`. |

### Companion Object Properties

| Name | Summary |
|---|---|
| [BOOL](-b-o-o-l.md) | `val BOOL: `[`ProtoAdapter`](./index.md)`<`[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`>` |
| [BYTES](-b-y-t-e-s.md) | `val BYTES: `[`ProtoAdapter`](./index.md)`<<ERROR CLASS>>` |
| [DOUBLE](-d-o-u-b-l-e.md) | `val DOUBLE: `[`ProtoAdapter`](./index.md)`<`[`Double`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)`>` |
| [FIXED32](-f-i-x-e-d32.md) | `val FIXED32: `[`ProtoAdapter`](./index.md)`<`[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`>` |
| [FIXED64](-f-i-x-e-d64.md) | `val FIXED64: `[`ProtoAdapter`](./index.md)`<`[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`>` |
| [FLOAT](-f-l-o-a-t.md) | `val FLOAT: `[`ProtoAdapter`](./index.md)`<`[`Float`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float/index.html)`>` |
| [INT32](-i-n-t32.md) | `val INT32: `[`ProtoAdapter`](./index.md)`<`[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`>` |
| [INT64](-i-n-t64.md) | `val INT64: `[`ProtoAdapter`](./index.md)`<`[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`>` |
| [SFIXED32](-s-f-i-x-e-d32.md) | `val SFIXED32: `[`ProtoAdapter`](./index.md)`<`[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`>` |
| [SFIXED64](-s-f-i-x-e-d64.md) | `val SFIXED64: `[`ProtoAdapter`](./index.md)`<`[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`>` |
| [SINT32](-s-i-n-t32.md) | `val SINT32: `[`ProtoAdapter`](./index.md)`<`[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`>` |
| [SINT64](-s-i-n-t64.md) | `val SINT64: `[`ProtoAdapter`](./index.md)`<`[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`>` |
| [STRING](-s-t-r-i-n-g.md) | `val STRING: `[`ProtoAdapter`](./index.md)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`>` |
| [UINT32](-u-i-n-t32.md) | `val UINT32: `[`ProtoAdapter`](./index.md)`<`[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`>` |
| [UINT64](-u-i-n-t64.md) | `val UINT64: `[`ProtoAdapter`](./index.md)`<`[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`>`<br>Like INT64, but negative longs are interpreted as large positive values, and encoded that way in JSON. |

### Companion Object Functions

| Name | Summary |
|---|---|
| [get](get.md)<br>(JVM) | `fun <M : `[`Message`](../-message/index.md)`<*, *>> get(message: `[`M`](get.md#M)`): `[`ProtoAdapter`](./index.md)`<`[`M`](get.md#M)`>`<br>Returns the adapter for the type of `Message`.`fun <M> get(type: `[`Class`](http://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)`<`[`M`](get.md#M)`>): `[`ProtoAdapter`](./index.md)`<`[`M`](get.md#M)`>`<br>Returns the adapter for `type`.`fun get(adapterString: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`ProtoAdapter`](./index.md)`<*>`<br>Returns the adapter for a given `adapterString`. `adapterString` is specified on a proto message field's [WireField](#) annotation in the form `com.squareup.wire.protos.person.Person#ADAPTER`. |
| [newEnumAdapter](new-enum-adapter.md)<br>(JVM) | `fun <E> newEnumAdapter(type: `[`Class`](http://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)`<`[`E`](new-enum-adapter.md#E)`>): `[`EnumAdapter`](../-enum-adapter/index.md)`<`[`E`](new-enum-adapter.md#E)`>`<br>Creates a new proto adapter for `type`. |
| [newMapAdapter](new-map-adapter.md) | `fun <K, V> newMapAdapter(keyAdapter: `[`ProtoAdapter`](./index.md)`<`[`K`](new-map-adapter.md#K)`>, valueAdapter: `[`ProtoAdapter`](./index.md)`<`[`V`](new-map-adapter.md#V)`>): `[`ProtoAdapter`](./index.md)`<`[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<`[`K`](new-map-adapter.md#K)`, `[`V`](new-map-adapter.md#V)`>>`<br>Creates a new proto adapter for a map using `keyAdapter` and `valueAdapter`. |
| [newMessageAdapter](new-message-adapter.md)<br>(JVM) | `fun <M : `[`Message`](../-message/index.md)`<`[`M`](new-message-adapter.md#M)`, `[`B`](new-message-adapter.md#B)`>, B : `[`Builder`](../-message/-builder/index.md)`<`[`M`](new-message-adapter.md#M)`, `[`B`](new-message-adapter.md#B)`>> newMessageAdapter(type: `[`Class`](http://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)`<`[`M`](new-message-adapter.md#M)`>): `[`ProtoAdapter`](./index.md)`<`[`M`](new-message-adapter.md#M)`>`<br>Creates a new proto adapter for `type`. |

### Inheritors

| Name | Summary |
|---|---|
| [EnumAdapter](../-enum-adapter/index.md)<br>(JVM, js, native) | `abstract expect class EnumAdapter<E : `[`WireEnum`](../-wire-enum/index.md)`> : `[`ProtoAdapter`](./index.md)`<`[`E`](../-enum-adapter/index.md#E)`>`<br>An abstract [ProtoAdapter](./index.md) that converts values of an enum to and from integers. |
