[wire-runtime](../../index.md) / [com.squareup.wire](../index.md) / [WireRpc](./index.md)

# WireRpc

`@Target([AnnotationTarget.FUNCTION]) annotation class WireRpc`

For gRPC actions the path is formatted as `/<service name>/<method name>`. The path of the proto
service below is `/squareup.helloworld.Greeter/SayHello`.

```
package squareup.helloworld;

service Greeter {
  rpc SayHello (HelloRequest) returns (HelloReply) {}
}
```

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `WireRpc(path: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, requestAdapter: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, responseAdapter: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`)`<br>For gRPC actions the path is formatted as `/<service name>/<method name>`. The path of the proto service below is `/squareup.helloworld.Greeter/SayHello`. |

### Properties

| Name | Summary |
|---|---|
| [path](path.md) | `val path: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [requestAdapter](request-adapter.md) | `val requestAdapter: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [responseAdapter](response-adapter.md) | `val responseAdapter: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
