[wire-schema](../../index.md) / [com.squareup.wire.schema](../index.md) / [Location](./index.md)

# Location

`data class Location`

Locates a .proto file, or a position within a .proto file, on the file system. This includes a
base directory or a .jar file, and a path relative to that base.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `Location(base: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, path: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, line: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = -1, column: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = -1)`<br>Locates a .proto file, or a position within a .proto file, on the file system. This includes a base directory or a .jar file, and a path relative to that base. |

### Properties

| Name | Summary |
|---|---|
| [base](base.md) | `val base: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>The base of this location; typically a directory or .jar file. |
| [column](column.md) | `val column: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>The column on the line of this location, or -1 for no specific column. |
| [line](line.md) | `val line: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>The line number of this location, or -1 for no specific line number. |
| [path](path.md) | `val path: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>The path to this location relative to [base](base.md). |

### Functions

| Name | Summary |
|---|---|
| [at](at.md) | `fun at(line: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, column: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Location`](./index.md) |
| [toString](to-string.md) | `fun toString(): <ERROR CLASS>` |
| [withPathOnly](with-path-only.md) | `fun withPathOnly(): `[`Location`](./index.md)<br>Returns a copy of this location including only its path. |
| [withoutBase](without-base.md) | `fun withoutBase(): `[`Location`](./index.md)<br>Returns a copy of this location with an empty base. |

### Companion Object Functions

| Name | Summary |
|---|---|
| [get](get.md) | `fun get(path: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Location`](./index.md)<br>`fun get(base: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, path: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Location`](./index.md) |
